/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.managedgrafana.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.managedgrafana.model.SamlConfiguration;
import java.util.List;

@SdkInternalApi
public class SamlConfigurationMarshaller {
    private static final MarshallingInfo<List> ALLOWEDORGANIZATIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("allowedOrganizations").build();
    private static final MarshallingInfo<StructuredPojo> ASSERTIONATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("assertionAttributes").build();
    private static final MarshallingInfo<StructuredPojo> IDPMETADATA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("idpMetadata").build();
    private static final MarshallingInfo<Integer> LOGINVALIDITYDURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("loginValidityDuration").build();
    private static final MarshallingInfo<StructuredPojo> ROLEVALUES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("roleValues").build();
    private static final SamlConfigurationMarshaller instance = new SamlConfigurationMarshaller();

    public static SamlConfigurationMarshaller getInstance() {
        return instance;
    }

    public void marshall(SamlConfiguration samlConfiguration, ProtocolMarshaller protocolMarshaller) {
        if (samlConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(samlConfiguration.getAllowedOrganizations(), ALLOWEDORGANIZATIONS_BINDING);
            protocolMarshaller.marshall((Object)samlConfiguration.getAssertionAttributes(), ASSERTIONATTRIBUTES_BINDING);
            protocolMarshaller.marshall((Object)samlConfiguration.getIdpMetadata(), IDPMETADATA_BINDING);
            protocolMarshaller.marshall((Object)samlConfiguration.getLoginValidityDuration(), LOGINVALIDITYDURATION_BINDING);
            protocolMarshaller.marshall((Object)samlConfiguration.getRoleValues(), ROLEVALUES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

