/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.managedgrafana.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.managedgrafana.model.AuthenticationProviderTypes;
import com.amazonaws.services.managedgrafana.model.SamlConfigurationStatus;
import com.amazonaws.services.managedgrafana.model.transform.AuthenticationSummaryMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AuthenticationSummary
implements Serializable,
Cloneable,
StructuredPojo {
    private List<String> providers;
    private String samlConfigurationStatus;

    public List<String> getProviders() {
        return this.providers;
    }

    public void setProviders(Collection<String> providers) {
        if (providers == null) {
            this.providers = null;
            return;
        }
        this.providers = new ArrayList<String>(providers);
    }

    public AuthenticationSummary withProviders(String ... providers) {
        if (this.providers == null) {
            this.setProviders(new ArrayList<String>(providers.length));
        }
        for (String ele : providers) {
            this.providers.add(ele);
        }
        return this;
    }

    public AuthenticationSummary withProviders(Collection<String> providers) {
        this.setProviders(providers);
        return this;
    }

    public AuthenticationSummary withProviders(AuthenticationProviderTypes ... providers) {
        ArrayList<String> providersCopy = new ArrayList<String>(providers.length);
        for (AuthenticationProviderTypes value : providers) {
            providersCopy.add(value.toString());
        }
        if (this.getProviders() == null) {
            this.setProviders(providersCopy);
        } else {
            this.getProviders().addAll(providersCopy);
        }
        return this;
    }

    public void setSamlConfigurationStatus(String samlConfigurationStatus) {
        this.samlConfigurationStatus = samlConfigurationStatus;
    }

    public String getSamlConfigurationStatus() {
        return this.samlConfigurationStatus;
    }

    public AuthenticationSummary withSamlConfigurationStatus(String samlConfigurationStatus) {
        this.setSamlConfigurationStatus(samlConfigurationStatus);
        return this;
    }

    public AuthenticationSummary withSamlConfigurationStatus(SamlConfigurationStatus samlConfigurationStatus) {
        this.samlConfigurationStatus = samlConfigurationStatus.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getProviders() != null) {
            sb.append("Providers: ").append(this.getProviders()).append(",");
        }
        if (this.getSamlConfigurationStatus() != null) {
            sb.append("SamlConfigurationStatus: ").append(this.getSamlConfigurationStatus());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthenticationSummary)) {
            return false;
        }
        AuthenticationSummary other = (AuthenticationSummary)obj;
        if (other.getProviders() == null ^ this.getProviders() == null) {
            return false;
        }
        if (other.getProviders() != null && !other.getProviders().equals(this.getProviders())) {
            return false;
        }
        if (other.getSamlConfigurationStatus() == null ^ this.getSamlConfigurationStatus() == null) {
            return false;
        }
        return other.getSamlConfigurationStatus() == null || other.getSamlConfigurationStatus().equals(this.getSamlConfigurationStatus());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getProviders() == null ? 0 : this.getProviders().hashCode());
        hashCode = 31 * hashCode + (this.getSamlConfigurationStatus() == null ? 0 : this.getSamlConfigurationStatus().hashCode());
        return hashCode;
    }

    public AuthenticationSummary clone() {
        try {
            return (AuthenticationSummary)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AuthenticationSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

