/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mainframemodernization.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.mainframemodernization.model.EngineType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListEnvironmentsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String engineType;
    private Integer maxResults;
    private List<String> names;
    private String nextToken;

    public void setEngineType(String engineType) {
        this.engineType = engineType;
    }

    public String getEngineType() {
        return this.engineType;
    }

    public ListEnvironmentsRequest withEngineType(String engineType) {
        this.setEngineType(engineType);
        return this;
    }

    public ListEnvironmentsRequest withEngineType(EngineType engineType) {
        this.engineType = engineType.toString();
        return this;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public ListEnvironmentsRequest withMaxResults(Integer maxResults) {
        this.setMaxResults(maxResults);
        return this;
    }

    public List<String> getNames() {
        return this.names;
    }

    public void setNames(Collection<String> names) {
        if (names == null) {
            this.names = null;
            return;
        }
        this.names = new ArrayList<String>(names);
    }

    public ListEnvironmentsRequest withNames(String ... names) {
        if (this.names == null) {
            this.setNames(new ArrayList<String>(names.length));
        }
        for (String ele : names) {
            this.names.add(ele);
        }
        return this;
    }

    public ListEnvironmentsRequest withNames(Collection<String> names) {
        this.setNames(names);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListEnvironmentsRequest withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEngineType() != null) {
            sb.append("EngineType: ").append(this.getEngineType()).append(",");
        }
        if (this.getMaxResults() != null) {
            sb.append("MaxResults: ").append(this.getMaxResults()).append(",");
        }
        if (this.getNames() != null) {
            sb.append("Names: ").append(this.getNames()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEnvironmentsRequest)) {
            return false;
        }
        ListEnvironmentsRequest other = (ListEnvironmentsRequest)obj;
        if (other.getEngineType() == null ^ this.getEngineType() == null) {
            return false;
        }
        if (other.getEngineType() != null && !other.getEngineType().equals(this.getEngineType())) {
            return false;
        }
        if (other.getMaxResults() == null ^ this.getMaxResults() == null) {
            return false;
        }
        if (other.getMaxResults() != null && !other.getMaxResults().equals(this.getMaxResults())) {
            return false;
        }
        if (other.getNames() == null ^ this.getNames() == null) {
            return false;
        }
        if (other.getNames() != null && !other.getNames().equals(this.getNames())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEngineType() == null ? 0 : this.getEngineType().hashCode());
        hashCode = 31 * hashCode + (this.getMaxResults() == null ? 0 : this.getMaxResults().hashCode());
        hashCode = 31 * hashCode + (this.getNames() == null ? 0 : this.getNames().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListEnvironmentsRequest clone() {
        return (ListEnvironmentsRequest)super.clone();
    }
}

