/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mailmanager.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.mailmanager.model.Relay;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListRelaysResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String nextToken;
    private List<Relay> relays;

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListRelaysResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public List<Relay> getRelays() {
        return this.relays;
    }

    public void setRelays(Collection<Relay> relays) {
        if (relays == null) {
            this.relays = null;
            return;
        }
        this.relays = new ArrayList<Relay>(relays);
    }

    public ListRelaysResult withRelays(Relay ... relays) {
        if (this.relays == null) {
            this.setRelays(new ArrayList<Relay>(relays.length));
        }
        for (Relay ele : relays) {
            this.relays.add(ele);
        }
        return this;
    }

    public ListRelaysResult withRelays(Collection<Relay> relays) {
        this.setRelays(relays);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getRelays() != null) {
            sb.append("Relays: ").append(this.getRelays());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRelaysResult)) {
            return false;
        }
        ListRelaysResult other = (ListRelaysResult)obj;
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getRelays() == null ^ this.getRelays() == null) {
            return false;
        }
        return other.getRelays() == null || other.getRelays().equals(this.getRelays());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getRelays() == null ? 0 : this.getRelays().hashCode());
        return hashCode;
    }

    public ListRelaysResult clone() {
        try {
            return (ListRelaysResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

