/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mailmanager.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.mailmanager.model.ArchiveRetention;
import com.amazonaws.services.mailmanager.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateArchiveRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String archiveName;
    private String clientToken;
    private String kmsKeyArn;
    private ArchiveRetention retention;
    private List<Tag> tags;

    public void setArchiveName(String archiveName) {
        this.archiveName = archiveName;
    }

    public String getArchiveName() {
        return this.archiveName;
    }

    public CreateArchiveRequest withArchiveName(String archiveName) {
        this.setArchiveName(archiveName);
        return this;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public CreateArchiveRequest withClientToken(String clientToken) {
        this.setClientToken(clientToken);
        return this;
    }

    public void setKmsKeyArn(String kmsKeyArn) {
        this.kmsKeyArn = kmsKeyArn;
    }

    public String getKmsKeyArn() {
        return this.kmsKeyArn;
    }

    public CreateArchiveRequest withKmsKeyArn(String kmsKeyArn) {
        this.setKmsKeyArn(kmsKeyArn);
        return this;
    }

    public void setRetention(ArchiveRetention retention) {
        this.retention = retention;
    }

    public ArchiveRetention getRetention() {
        return this.retention;
    }

    public CreateArchiveRequest withRetention(ArchiveRetention retention) {
        this.setRetention(retention);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public CreateArchiveRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreateArchiveRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getArchiveName() != null) {
            sb.append("ArchiveName: ").append(this.getArchiveName()).append(",");
        }
        if (this.getClientToken() != null) {
            sb.append("ClientToken: ").append(this.getClientToken()).append(",");
        }
        if (this.getKmsKeyArn() != null) {
            sb.append("KmsKeyArn: ").append(this.getKmsKeyArn()).append(",");
        }
        if (this.getRetention() != null) {
            sb.append("Retention: ").append(this.getRetention()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateArchiveRequest)) {
            return false;
        }
        CreateArchiveRequest other = (CreateArchiveRequest)obj;
        if (other.getArchiveName() == null ^ this.getArchiveName() == null) {
            return false;
        }
        if (other.getArchiveName() != null && !other.getArchiveName().equals(this.getArchiveName())) {
            return false;
        }
        if (other.getClientToken() == null ^ this.getClientToken() == null) {
            return false;
        }
        if (other.getClientToken() != null && !other.getClientToken().equals(this.getClientToken())) {
            return false;
        }
        if (other.getKmsKeyArn() == null ^ this.getKmsKeyArn() == null) {
            return false;
        }
        if (other.getKmsKeyArn() != null && !other.getKmsKeyArn().equals(this.getKmsKeyArn())) {
            return false;
        }
        if (other.getRetention() == null ^ this.getRetention() == null) {
            return false;
        }
        if (other.getRetention() != null && !other.getRetention().equals(this.getRetention())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getArchiveName() == null ? 0 : this.getArchiveName().hashCode());
        hashCode = 31 * hashCode + (this.getClientToken() == null ? 0 : this.getClientToken().hashCode());
        hashCode = 31 * hashCode + (this.getKmsKeyArn() == null ? 0 : this.getKmsKeyArn().hashCode());
        hashCode = 31 * hashCode + (this.getRetention() == null ? 0 : this.getRetention().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public CreateArchiveRequest clone() {
        return (CreateArchiveRequest)super.clone();
    }
}

