/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lookoutmetrics.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.lookoutmetrics.model.DimensionNameValue;
import com.amazonaws.services.lookoutmetrics.model.transform.TimeSeriesMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class TimeSeries
implements Serializable,
Cloneable,
StructuredPojo {
    private String timeSeriesId;
    private List<DimensionNameValue> dimensionList;
    private List<Double> metricValueList;

    public void setTimeSeriesId(String timeSeriesId) {
        this.timeSeriesId = timeSeriesId;
    }

    public String getTimeSeriesId() {
        return this.timeSeriesId;
    }

    public TimeSeries withTimeSeriesId(String timeSeriesId) {
        this.setTimeSeriesId(timeSeriesId);
        return this;
    }

    public List<DimensionNameValue> getDimensionList() {
        return this.dimensionList;
    }

    public void setDimensionList(Collection<DimensionNameValue> dimensionList) {
        if (dimensionList == null) {
            this.dimensionList = null;
            return;
        }
        this.dimensionList = new ArrayList<DimensionNameValue>(dimensionList);
    }

    public TimeSeries withDimensionList(DimensionNameValue ... dimensionList) {
        if (this.dimensionList == null) {
            this.setDimensionList(new ArrayList<DimensionNameValue>(dimensionList.length));
        }
        for (DimensionNameValue ele : dimensionList) {
            this.dimensionList.add(ele);
        }
        return this;
    }

    public TimeSeries withDimensionList(Collection<DimensionNameValue> dimensionList) {
        this.setDimensionList(dimensionList);
        return this;
    }

    public List<Double> getMetricValueList() {
        return this.metricValueList;
    }

    public void setMetricValueList(Collection<Double> metricValueList) {
        if (metricValueList == null) {
            this.metricValueList = null;
            return;
        }
        this.metricValueList = new ArrayList<Double>(metricValueList);
    }

    public TimeSeries withMetricValueList(Double ... metricValueList) {
        if (this.metricValueList == null) {
            this.setMetricValueList(new ArrayList<Double>(metricValueList.length));
        }
        for (Double ele : metricValueList) {
            this.metricValueList.add(ele);
        }
        return this;
    }

    public TimeSeries withMetricValueList(Collection<Double> metricValueList) {
        this.setMetricValueList(metricValueList);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTimeSeriesId() != null) {
            sb.append("TimeSeriesId: ").append(this.getTimeSeriesId()).append(",");
        }
        if (this.getDimensionList() != null) {
            sb.append("DimensionList: ").append(this.getDimensionList()).append(",");
        }
        if (this.getMetricValueList() != null) {
            sb.append("MetricValueList: ").append(this.getMetricValueList());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimeSeries)) {
            return false;
        }
        TimeSeries other = (TimeSeries)obj;
        if (other.getTimeSeriesId() == null ^ this.getTimeSeriesId() == null) {
            return false;
        }
        if (other.getTimeSeriesId() != null && !other.getTimeSeriesId().equals(this.getTimeSeriesId())) {
            return false;
        }
        if (other.getDimensionList() == null ^ this.getDimensionList() == null) {
            return false;
        }
        if (other.getDimensionList() != null && !other.getDimensionList().equals(this.getDimensionList())) {
            return false;
        }
        if (other.getMetricValueList() == null ^ this.getMetricValueList() == null) {
            return false;
        }
        return other.getMetricValueList() == null || other.getMetricValueList().equals(this.getMetricValueList());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTimeSeriesId() == null ? 0 : this.getTimeSeriesId().hashCode());
        hashCode = 31 * hashCode + (this.getDimensionList() == null ? 0 : this.getDimensionList().hashCode());
        hashCode = 31 * hashCode + (this.getMetricValueList() == null ? 0 : this.getMetricValueList().hashCode());
        return hashCode;
    }

    public TimeSeries clone() {
        try {
            return (TimeSeries)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TimeSeriesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

