/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lookoutmetrics.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.lookoutmetrics.model.transform.DimensionFilterMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DimensionFilter
implements Serializable,
Cloneable,
StructuredPojo {
    private String dimensionName;
    private List<String> dimensionValueList;

    public void setDimensionName(String dimensionName) {
        this.dimensionName = dimensionName;
    }

    public String getDimensionName() {
        return this.dimensionName;
    }

    public DimensionFilter withDimensionName(String dimensionName) {
        this.setDimensionName(dimensionName);
        return this;
    }

    public List<String> getDimensionValueList() {
        return this.dimensionValueList;
    }

    public void setDimensionValueList(Collection<String> dimensionValueList) {
        if (dimensionValueList == null) {
            this.dimensionValueList = null;
            return;
        }
        this.dimensionValueList = new ArrayList<String>(dimensionValueList);
    }

    public DimensionFilter withDimensionValueList(String ... dimensionValueList) {
        if (this.dimensionValueList == null) {
            this.setDimensionValueList(new ArrayList<String>(dimensionValueList.length));
        }
        for (String ele : dimensionValueList) {
            this.dimensionValueList.add(ele);
        }
        return this;
    }

    public DimensionFilter withDimensionValueList(Collection<String> dimensionValueList) {
        this.setDimensionValueList(dimensionValueList);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDimensionName() != null) {
            sb.append("DimensionName: ").append(this.getDimensionName()).append(",");
        }
        if (this.getDimensionValueList() != null) {
            sb.append("DimensionValueList: ").append(this.getDimensionValueList());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DimensionFilter)) {
            return false;
        }
        DimensionFilter other = (DimensionFilter)obj;
        if (other.getDimensionName() == null ^ this.getDimensionName() == null) {
            return false;
        }
        if (other.getDimensionName() != null && !other.getDimensionName().equals(this.getDimensionName())) {
            return false;
        }
        if (other.getDimensionValueList() == null ^ this.getDimensionValueList() == null) {
            return false;
        }
        return other.getDimensionValueList() == null || other.getDimensionValueList().equals(this.getDimensionValueList());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDimensionName() == null ? 0 : this.getDimensionName().hashCode());
        hashCode = 31 * hashCode + (this.getDimensionValueList() == null ? 0 : this.getDimensionValueList().hashCode());
        return hashCode;
    }

    public DimensionFilter clone() {
        try {
            return (DimensionFilter)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DimensionFilterMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

