/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lookoutforvision.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.lookoutforvision.model.CreateModelRequest;
import com.amazonaws.util.IdempotentUtils;
import java.util.List;

@SdkInternalApi
public class CreateModelRequestMarshaller {
    private static final MarshallingInfo<String> PROJECTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("projectName").build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").build();
    private static final MarshallingInfo<String> CLIENTTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.HEADER).marshallLocationName("X-Amzn-Client-Token").defaultValueSupplier(IdempotentUtils.getGenerator()).build();
    private static final MarshallingInfo<StructuredPojo> OUTPUTCONFIG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OutputConfig").build();
    private static final MarshallingInfo<String> KMSKEYID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KmsKeyId").build();
    private static final MarshallingInfo<List> TAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Tags").build();
    private static final CreateModelRequestMarshaller instance = new CreateModelRequestMarshaller();

    public static CreateModelRequestMarshaller getInstance() {
        return instance;
    }

    public void marshall(CreateModelRequest createModelRequest, ProtocolMarshaller protocolMarshaller) {
        if (createModelRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)createModelRequest.getProjectName(), PROJECTNAME_BINDING);
            protocolMarshaller.marshall((Object)createModelRequest.getDescription(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)createModelRequest.getClientToken(), CLIENTTOKEN_BINDING);
            protocolMarshaller.marshall((Object)createModelRequest.getOutputConfig(), OUTPUTCONFIG_BINDING);
            protocolMarshaller.marshall((Object)createModelRequest.getKmsKeyId(), KMSKEYID_BINDING);
            protocolMarshaller.marshall(createModelRequest.getTags(), TAGS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

