/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lookoutforvision.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.lookoutforvision.model.ProjectDescription;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class ProjectDescriptionMarshaller {
    private static final MarshallingInfo<String> PROJECTARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProjectArn").build();
    private static final MarshallingInfo<String> PROJECTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProjectName").build();
    private static final MarshallingInfo<Date> CREATIONTIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationTimestamp").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<List> DATASETS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Datasets").build();
    private static final ProjectDescriptionMarshaller instance = new ProjectDescriptionMarshaller();

    public static ProjectDescriptionMarshaller getInstance() {
        return instance;
    }

    public void marshall(ProjectDescription projectDescription, ProtocolMarshaller protocolMarshaller) {
        if (projectDescription == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)projectDescription.getProjectArn(), PROJECTARN_BINDING);
            protocolMarshaller.marshall((Object)projectDescription.getProjectName(), PROJECTNAME_BINDING);
            protocolMarshaller.marshall((Object)projectDescription.getCreationTimestamp(), CREATIONTIMESTAMP_BINDING);
            protocolMarshaller.marshall(projectDescription.getDatasets(), DATASETS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

