/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.location.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.location.model.DataSourceConfiguration;

@SdkInternalApi
public class DataSourceConfigurationMarshaller {
    private static final MarshallingInfo<String> INTENDEDUSE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IntendedUse").build();
    private static final DataSourceConfigurationMarshaller instance = new DataSourceConfigurationMarshaller();

    public static DataSourceConfigurationMarshaller getInstance() {
        return instance;
    }

    public void marshall(DataSourceConfiguration dataSourceConfiguration, ProtocolMarshaller protocolMarshaller) {
        if (dataSourceConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)dataSourceConfiguration.getIntendedUse(), INTENDEDUSE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

