/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lightsail.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.lightsail.model.BucketMetricName;
import com.amazonaws.services.lightsail.model.MetricStatistic;
import com.amazonaws.services.lightsail.model.MetricUnit;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class GetBucketMetricDataRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String bucketName;
    private String metricName;
    private Date startTime;
    private Date endTime;
    private Integer period;
    private List<String> statistics;
    private String unit;

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public GetBucketMetricDataRequest withBucketName(String bucketName) {
        this.setBucketName(bucketName);
        return this;
    }

    public void setMetricName(String metricName) {
        this.metricName = metricName;
    }

    public String getMetricName() {
        return this.metricName;
    }

    public GetBucketMetricDataRequest withMetricName(String metricName) {
        this.setMetricName(metricName);
        return this;
    }

    public GetBucketMetricDataRequest withMetricName(BucketMetricName metricName) {
        this.metricName = metricName.toString();
        return this;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public GetBucketMetricDataRequest withStartTime(Date startTime) {
        this.setStartTime(startTime);
        return this;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public GetBucketMetricDataRequest withEndTime(Date endTime) {
        this.setEndTime(endTime);
        return this;
    }

    public void setPeriod(Integer period) {
        this.period = period;
    }

    public Integer getPeriod() {
        return this.period;
    }

    public GetBucketMetricDataRequest withPeriod(Integer period) {
        this.setPeriod(period);
        return this;
    }

    public List<String> getStatistics() {
        return this.statistics;
    }

    public void setStatistics(Collection<String> statistics) {
        if (statistics == null) {
            this.statistics = null;
            return;
        }
        this.statistics = new ArrayList<String>(statistics);
    }

    public GetBucketMetricDataRequest withStatistics(String ... statistics) {
        if (this.statistics == null) {
            this.setStatistics(new ArrayList<String>(statistics.length));
        }
        for (String ele : statistics) {
            this.statistics.add(ele);
        }
        return this;
    }

    public GetBucketMetricDataRequest withStatistics(Collection<String> statistics) {
        this.setStatistics(statistics);
        return this;
    }

    public GetBucketMetricDataRequest withStatistics(MetricStatistic ... statistics) {
        ArrayList<String> statisticsCopy = new ArrayList<String>(statistics.length);
        for (MetricStatistic value : statistics) {
            statisticsCopy.add(value.toString());
        }
        if (this.getStatistics() == null) {
            this.setStatistics(statisticsCopy);
        } else {
            this.getStatistics().addAll(statisticsCopy);
        }
        return this;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public String getUnit() {
        return this.unit;
    }

    public GetBucketMetricDataRequest withUnit(String unit) {
        this.setUnit(unit);
        return this;
    }

    public GetBucketMetricDataRequest withUnit(MetricUnit unit) {
        this.unit = unit.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getBucketName() != null) {
            sb.append("BucketName: ").append(this.getBucketName()).append(",");
        }
        if (this.getMetricName() != null) {
            sb.append("MetricName: ").append(this.getMetricName()).append(",");
        }
        if (this.getStartTime() != null) {
            sb.append("StartTime: ").append(this.getStartTime()).append(",");
        }
        if (this.getEndTime() != null) {
            sb.append("EndTime: ").append(this.getEndTime()).append(",");
        }
        if (this.getPeriod() != null) {
            sb.append("Period: ").append(this.getPeriod()).append(",");
        }
        if (this.getStatistics() != null) {
            sb.append("Statistics: ").append(this.getStatistics()).append(",");
        }
        if (this.getUnit() != null) {
            sb.append("Unit: ").append(this.getUnit());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBucketMetricDataRequest)) {
            return false;
        }
        GetBucketMetricDataRequest other = (GetBucketMetricDataRequest)obj;
        if (other.getBucketName() == null ^ this.getBucketName() == null) {
            return false;
        }
        if (other.getBucketName() != null && !other.getBucketName().equals(this.getBucketName())) {
            return false;
        }
        if (other.getMetricName() == null ^ this.getMetricName() == null) {
            return false;
        }
        if (other.getMetricName() != null && !other.getMetricName().equals(this.getMetricName())) {
            return false;
        }
        if (other.getStartTime() == null ^ this.getStartTime() == null) {
            return false;
        }
        if (other.getStartTime() != null && !other.getStartTime().equals(this.getStartTime())) {
            return false;
        }
        if (other.getEndTime() == null ^ this.getEndTime() == null) {
            return false;
        }
        if (other.getEndTime() != null && !other.getEndTime().equals(this.getEndTime())) {
            return false;
        }
        if (other.getPeriod() == null ^ this.getPeriod() == null) {
            return false;
        }
        if (other.getPeriod() != null && !other.getPeriod().equals(this.getPeriod())) {
            return false;
        }
        if (other.getStatistics() == null ^ this.getStatistics() == null) {
            return false;
        }
        if (other.getStatistics() != null && !other.getStatistics().equals(this.getStatistics())) {
            return false;
        }
        if (other.getUnit() == null ^ this.getUnit() == null) {
            return false;
        }
        return other.getUnit() == null || other.getUnit().equals(this.getUnit());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getBucketName() == null ? 0 : this.getBucketName().hashCode());
        hashCode = 31 * hashCode + (this.getMetricName() == null ? 0 : this.getMetricName().hashCode());
        hashCode = 31 * hashCode + (this.getStartTime() == null ? 0 : this.getStartTime().hashCode());
        hashCode = 31 * hashCode + (this.getEndTime() == null ? 0 : this.getEndTime().hashCode());
        hashCode = 31 * hashCode + (this.getPeriod() == null ? 0 : this.getPeriod().hashCode());
        hashCode = 31 * hashCode + (this.getStatistics() == null ? 0 : this.getStatistics().hashCode());
        hashCode = 31 * hashCode + (this.getUnit() == null ? 0 : this.getUnit().hashCode());
        return hashCode;
    }

    public GetBucketMetricDataRequest clone() {
        return (GetBucketMetricDataRequest)super.clone();
    }
}

