/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lightsail.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.lightsail.model.ContainerServiceDeploymentRequest;
import com.amazonaws.services.lightsail.model.ContainerServicePowerName;
import com.amazonaws.services.lightsail.model.PrivateRegistryAccessRequest;
import com.amazonaws.services.lightsail.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CreateContainerServiceRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String serviceName;
    private String power;
    private Integer scale;
    private List<Tag> tags;
    private Map<String, List<String>> publicDomainNames;
    private ContainerServiceDeploymentRequest deployment;
    private PrivateRegistryAccessRequest privateRegistryAccess;

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public CreateContainerServiceRequest withServiceName(String serviceName) {
        this.setServiceName(serviceName);
        return this;
    }

    public void setPower(String power) {
        this.power = power;
    }

    public String getPower() {
        return this.power;
    }

    public CreateContainerServiceRequest withPower(String power) {
        this.setPower(power);
        return this;
    }

    public CreateContainerServiceRequest withPower(ContainerServicePowerName power) {
        this.power = power.toString();
        return this;
    }

    public void setScale(Integer scale) {
        this.scale = scale;
    }

    public Integer getScale() {
        return this.scale;
    }

    public CreateContainerServiceRequest withScale(Integer scale) {
        this.setScale(scale);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public CreateContainerServiceRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreateContainerServiceRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public Map<String, List<String>> getPublicDomainNames() {
        return this.publicDomainNames;
    }

    public void setPublicDomainNames(Map<String, List<String>> publicDomainNames) {
        this.publicDomainNames = publicDomainNames;
    }

    public CreateContainerServiceRequest withPublicDomainNames(Map<String, List<String>> publicDomainNames) {
        this.setPublicDomainNames(publicDomainNames);
        return this;
    }

    public CreateContainerServiceRequest addPublicDomainNamesEntry(String key, List<String> value) {
        if (null == this.publicDomainNames) {
            this.publicDomainNames = new HashMap<String, List<String>>();
        }
        if (this.publicDomainNames.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.publicDomainNames.put(key, value);
        return this;
    }

    public CreateContainerServiceRequest clearPublicDomainNamesEntries() {
        this.publicDomainNames = null;
        return this;
    }

    public void setDeployment(ContainerServiceDeploymentRequest deployment) {
        this.deployment = deployment;
    }

    public ContainerServiceDeploymentRequest getDeployment() {
        return this.deployment;
    }

    public CreateContainerServiceRequest withDeployment(ContainerServiceDeploymentRequest deployment) {
        this.setDeployment(deployment);
        return this;
    }

    public void setPrivateRegistryAccess(PrivateRegistryAccessRequest privateRegistryAccess) {
        this.privateRegistryAccess = privateRegistryAccess;
    }

    public PrivateRegistryAccessRequest getPrivateRegistryAccess() {
        return this.privateRegistryAccess;
    }

    public CreateContainerServiceRequest withPrivateRegistryAccess(PrivateRegistryAccessRequest privateRegistryAccess) {
        this.setPrivateRegistryAccess(privateRegistryAccess);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getServiceName() != null) {
            sb.append("ServiceName: ").append(this.getServiceName()).append(",");
        }
        if (this.getPower() != null) {
            sb.append("Power: ").append(this.getPower()).append(",");
        }
        if (this.getScale() != null) {
            sb.append("Scale: ").append(this.getScale()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getPublicDomainNames() != null) {
            sb.append("PublicDomainNames: ").append(this.getPublicDomainNames()).append(",");
        }
        if (this.getDeployment() != null) {
            sb.append("Deployment: ").append(this.getDeployment()).append(",");
        }
        if (this.getPrivateRegistryAccess() != null) {
            sb.append("PrivateRegistryAccess: ").append(this.getPrivateRegistryAccess());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateContainerServiceRequest)) {
            return false;
        }
        CreateContainerServiceRequest other = (CreateContainerServiceRequest)obj;
        if (other.getServiceName() == null ^ this.getServiceName() == null) {
            return false;
        }
        if (other.getServiceName() != null && !other.getServiceName().equals(this.getServiceName())) {
            return false;
        }
        if (other.getPower() == null ^ this.getPower() == null) {
            return false;
        }
        if (other.getPower() != null && !other.getPower().equals(this.getPower())) {
            return false;
        }
        if (other.getScale() == null ^ this.getScale() == null) {
            return false;
        }
        if (other.getScale() != null && !other.getScale().equals(this.getScale())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getPublicDomainNames() == null ^ this.getPublicDomainNames() == null) {
            return false;
        }
        if (other.getPublicDomainNames() != null && !other.getPublicDomainNames().equals(this.getPublicDomainNames())) {
            return false;
        }
        if (other.getDeployment() == null ^ this.getDeployment() == null) {
            return false;
        }
        if (other.getDeployment() != null && !other.getDeployment().equals(this.getDeployment())) {
            return false;
        }
        if (other.getPrivateRegistryAccess() == null ^ this.getPrivateRegistryAccess() == null) {
            return false;
        }
        return other.getPrivateRegistryAccess() == null || other.getPrivateRegistryAccess().equals(this.getPrivateRegistryAccess());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getServiceName() == null ? 0 : this.getServiceName().hashCode());
        hashCode = 31 * hashCode + (this.getPower() == null ? 0 : this.getPower().hashCode());
        hashCode = 31 * hashCode + (this.getScale() == null ? 0 : this.getScale().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getPublicDomainNames() == null ? 0 : this.getPublicDomainNames().hashCode());
        hashCode = 31 * hashCode + (this.getDeployment() == null ? 0 : this.getDeployment().hashCode());
        hashCode = 31 * hashCode + (this.getPrivateRegistryAccess() == null ? 0 : this.getPrivateRegistryAccess().hashCode());
        return hashCode;
    }

    public CreateContainerServiceRequest clone() {
        return (CreateContainerServiceRequest)super.clone();
    }
}

