/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lightsail.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.lightsail.model.DiskInfo;

@SdkInternalApi
public class DiskInfoMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").build();
    private static final MarshallingInfo<String> PATH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("path").build();
    private static final MarshallingInfo<Integer> SIZEINGB_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sizeInGb").build();
    private static final MarshallingInfo<Boolean> ISSYSTEMDISK_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("isSystemDisk").build();
    private static final DiskInfoMarshaller instance = new DiskInfoMarshaller();

    public static DiskInfoMarshaller getInstance() {
        return instance;
    }

    public void marshall(DiskInfo diskInfo, ProtocolMarshaller protocolMarshaller) {
        if (diskInfo == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)diskInfo.getName(), NAME_BINDING);
            protocolMarshaller.marshall((Object)diskInfo.getPath(), PATH_BINDING);
            protocolMarshaller.marshall((Object)diskInfo.getSizeInGb(), SIZEINGB_BINDING);
            protocolMarshaller.marshall((Object)diskInfo.getIsSystemDisk(), ISSYSTEMDISK_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

