/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lightsail.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.lightsail.model.RelationalDatabaseBlueprint;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GetRelationalDatabaseBlueprintsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<RelationalDatabaseBlueprint> blueprints;
    private String nextPageToken;

    public List<RelationalDatabaseBlueprint> getBlueprints() {
        return this.blueprints;
    }

    public void setBlueprints(Collection<RelationalDatabaseBlueprint> blueprints) {
        if (blueprints == null) {
            this.blueprints = null;
            return;
        }
        this.blueprints = new ArrayList<RelationalDatabaseBlueprint>(blueprints);
    }

    public GetRelationalDatabaseBlueprintsResult withBlueprints(RelationalDatabaseBlueprint ... blueprints) {
        if (this.blueprints == null) {
            this.setBlueprints(new ArrayList<RelationalDatabaseBlueprint>(blueprints.length));
        }
        for (RelationalDatabaseBlueprint ele : blueprints) {
            this.blueprints.add(ele);
        }
        return this;
    }

    public GetRelationalDatabaseBlueprintsResult withBlueprints(Collection<RelationalDatabaseBlueprint> blueprints) {
        this.setBlueprints(blueprints);
        return this;
    }

    public void setNextPageToken(String nextPageToken) {
        this.nextPageToken = nextPageToken;
    }

    public String getNextPageToken() {
        return this.nextPageToken;
    }

    public GetRelationalDatabaseBlueprintsResult withNextPageToken(String nextPageToken) {
        this.setNextPageToken(nextPageToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getBlueprints() != null) {
            sb.append("Blueprints: ").append(this.getBlueprints()).append(",");
        }
        if (this.getNextPageToken() != null) {
            sb.append("NextPageToken: ").append(this.getNextPageToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRelationalDatabaseBlueprintsResult)) {
            return false;
        }
        GetRelationalDatabaseBlueprintsResult other = (GetRelationalDatabaseBlueprintsResult)obj;
        if (other.getBlueprints() == null ^ this.getBlueprints() == null) {
            return false;
        }
        if (other.getBlueprints() != null && !other.getBlueprints().equals(this.getBlueprints())) {
            return false;
        }
        if (other.getNextPageToken() == null ^ this.getNextPageToken() == null) {
            return false;
        }
        return other.getNextPageToken() == null || other.getNextPageToken().equals(this.getNextPageToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getBlueprints() == null ? 0 : this.getBlueprints().hashCode());
        hashCode = 31 * hashCode + (this.getNextPageToken() == null ? 0 : this.getNextPageToken().hashCode());
        return hashCode;
    }

    public GetRelationalDatabaseBlueprintsResult clone() {
        try {
            return (GetRelationalDatabaseBlueprintsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

