/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lightsail.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.lightsail.model.Certificate;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class CertificateMarshaller {
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("arn").build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").build();
    private static final MarshallingInfo<String> DOMAINNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("domainName").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("status").build();
    private static final MarshallingInfo<String> SERIALNUMBER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("serialNumber").build();
    private static final MarshallingInfo<List> SUBJECTALTERNATIVENAMES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("subjectAlternativeNames").build();
    private static final MarshallingInfo<List> DOMAINVALIDATIONRECORDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("domainValidationRecords").build();
    private static final MarshallingInfo<String> REQUESTFAILUREREASON_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("requestFailureReason").build();
    private static final MarshallingInfo<Integer> INUSERESOURCECOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("inUseResourceCount").build();
    private static final MarshallingInfo<String> KEYALGORITHM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("keyAlgorithm").build();
    private static final MarshallingInfo<Date> CREATEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("createdAt").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> ISSUEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("issuedAt").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> ISSUERCA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("issuerCA").build();
    private static final MarshallingInfo<Date> NOTBEFORE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("notBefore").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> NOTAFTER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("notAfter").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> ELIGIBLETORENEW_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("eligibleToRenew").build();
    private static final MarshallingInfo<StructuredPojo> RENEWALSUMMARY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("renewalSummary").build();
    private static final MarshallingInfo<Date> REVOKEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("revokedAt").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> REVOCATIONREASON_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("revocationReason").build();
    private static final MarshallingInfo<List> TAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("tags").build();
    private static final MarshallingInfo<String> SUPPORTCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("supportCode").build();
    private static final CertificateMarshaller instance = new CertificateMarshaller();

    public static CertificateMarshaller getInstance() {
        return instance;
    }

    public void marshall(Certificate certificate, ProtocolMarshaller protocolMarshaller) {
        if (certificate == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)certificate.getArn(), ARN_BINDING);
            protocolMarshaller.marshall((Object)certificate.getName(), NAME_BINDING);
            protocolMarshaller.marshall((Object)certificate.getDomainName(), DOMAINNAME_BINDING);
            protocolMarshaller.marshall((Object)certificate.getStatus(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)certificate.getSerialNumber(), SERIALNUMBER_BINDING);
            protocolMarshaller.marshall(certificate.getSubjectAlternativeNames(), SUBJECTALTERNATIVENAMES_BINDING);
            protocolMarshaller.marshall(certificate.getDomainValidationRecords(), DOMAINVALIDATIONRECORDS_BINDING);
            protocolMarshaller.marshall((Object)certificate.getRequestFailureReason(), REQUESTFAILUREREASON_BINDING);
            protocolMarshaller.marshall((Object)certificate.getInUseResourceCount(), INUSERESOURCECOUNT_BINDING);
            protocolMarshaller.marshall((Object)certificate.getKeyAlgorithm(), KEYALGORITHM_BINDING);
            protocolMarshaller.marshall((Object)certificate.getCreatedAt(), CREATEDAT_BINDING);
            protocolMarshaller.marshall((Object)certificate.getIssuedAt(), ISSUEDAT_BINDING);
            protocolMarshaller.marshall((Object)certificate.getIssuerCA(), ISSUERCA_BINDING);
            protocolMarshaller.marshall((Object)certificate.getNotBefore(), NOTBEFORE_BINDING);
            protocolMarshaller.marshall((Object)certificate.getNotAfter(), NOTAFTER_BINDING);
            protocolMarshaller.marshall((Object)certificate.getEligibleToRenew(), ELIGIBLETORENEW_BINDING);
            protocolMarshaller.marshall((Object)certificate.getRenewalSummary(), RENEWALSUMMARY_BINDING);
            protocolMarshaller.marshall((Object)certificate.getRevokedAt(), REVOKEDAT_BINDING);
            protocolMarshaller.marshall((Object)certificate.getRevocationReason(), REVOCATIONREASON_BINDING);
            protocolMarshaller.marshall(certificate.getTags(), TAGS_BINDING);
            protocolMarshaller.marshall((Object)certificate.getSupportCode(), SUPPORTCODE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

