/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lightsail.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.lightsail.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateBucketRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String bucketName;
    private String bundleId;
    private List<Tag> tags;
    private Boolean enableObjectVersioning;

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public CreateBucketRequest withBucketName(String bucketName) {
        this.setBucketName(bucketName);
        return this;
    }

    public void setBundleId(String bundleId) {
        this.bundleId = bundleId;
    }

    public String getBundleId() {
        return this.bundleId;
    }

    public CreateBucketRequest withBundleId(String bundleId) {
        this.setBundleId(bundleId);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public CreateBucketRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreateBucketRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public void setEnableObjectVersioning(Boolean enableObjectVersioning) {
        this.enableObjectVersioning = enableObjectVersioning;
    }

    public Boolean getEnableObjectVersioning() {
        return this.enableObjectVersioning;
    }

    public CreateBucketRequest withEnableObjectVersioning(Boolean enableObjectVersioning) {
        this.setEnableObjectVersioning(enableObjectVersioning);
        return this;
    }

    public Boolean isEnableObjectVersioning() {
        return this.enableObjectVersioning;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getBucketName() != null) {
            sb.append("BucketName: ").append(this.getBucketName()).append(",");
        }
        if (this.getBundleId() != null) {
            sb.append("BundleId: ").append(this.getBundleId()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getEnableObjectVersioning() != null) {
            sb.append("EnableObjectVersioning: ").append(this.getEnableObjectVersioning());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateBucketRequest)) {
            return false;
        }
        CreateBucketRequest other = (CreateBucketRequest)obj;
        if (other.getBucketName() == null ^ this.getBucketName() == null) {
            return false;
        }
        if (other.getBucketName() != null && !other.getBucketName().equals(this.getBucketName())) {
            return false;
        }
        if (other.getBundleId() == null ^ this.getBundleId() == null) {
            return false;
        }
        if (other.getBundleId() != null && !other.getBundleId().equals(this.getBundleId())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getEnableObjectVersioning() == null ^ this.getEnableObjectVersioning() == null) {
            return false;
        }
        return other.getEnableObjectVersioning() == null || other.getEnableObjectVersioning().equals(this.getEnableObjectVersioning());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getBucketName() == null ? 0 : this.getBucketName().hashCode());
        hashCode = 31 * hashCode + (this.getBundleId() == null ? 0 : this.getBundleId().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getEnableObjectVersioning() == null ? 0 : this.getEnableObjectVersioning().hashCode());
        return hashCode;
    }

    public CreateBucketRequest clone() {
        return (CreateBucketRequest)super.clone();
    }
}

