/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lexruntimev2;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.lexruntimev2.AmazonLexRuntimeV2;
import com.amazonaws.services.lexruntimev2.AmazonLexRuntimeV2ClientBuilder;
import com.amazonaws.services.lexruntimev2.model.AmazonLexRuntimeV2Exception;
import com.amazonaws.services.lexruntimev2.model.DeleteSessionRequest;
import com.amazonaws.services.lexruntimev2.model.DeleteSessionResult;
import com.amazonaws.services.lexruntimev2.model.GetSessionRequest;
import com.amazonaws.services.lexruntimev2.model.GetSessionResult;
import com.amazonaws.services.lexruntimev2.model.PutSessionRequest;
import com.amazonaws.services.lexruntimev2.model.PutSessionResult;
import com.amazonaws.services.lexruntimev2.model.RecognizeTextRequest;
import com.amazonaws.services.lexruntimev2.model.RecognizeTextResult;
import com.amazonaws.services.lexruntimev2.model.RecognizeUtteranceRequest;
import com.amazonaws.services.lexruntimev2.model.RecognizeUtteranceResult;
import com.amazonaws.services.lexruntimev2.model.transform.AccessDeniedExceptionUnmarshaller;
import com.amazonaws.services.lexruntimev2.model.transform.BadGatewayExceptionUnmarshaller;
import com.amazonaws.services.lexruntimev2.model.transform.ConflictExceptionUnmarshaller;
import com.amazonaws.services.lexruntimev2.model.transform.DeleteSessionRequestProtocolMarshaller;
import com.amazonaws.services.lexruntimev2.model.transform.DeleteSessionResultJsonUnmarshaller;
import com.amazonaws.services.lexruntimev2.model.transform.DependencyFailedExceptionUnmarshaller;
import com.amazonaws.services.lexruntimev2.model.transform.GetSessionRequestProtocolMarshaller;
import com.amazonaws.services.lexruntimev2.model.transform.GetSessionResultJsonUnmarshaller;
import com.amazonaws.services.lexruntimev2.model.transform.InternalServerExceptionUnmarshaller;
import com.amazonaws.services.lexruntimev2.model.transform.PutSessionRequestProtocolMarshaller;
import com.amazonaws.services.lexruntimev2.model.transform.PutSessionResultJsonUnmarshaller;
import com.amazonaws.services.lexruntimev2.model.transform.RecognizeTextRequestProtocolMarshaller;
import com.amazonaws.services.lexruntimev2.model.transform.RecognizeTextResultJsonUnmarshaller;
import com.amazonaws.services.lexruntimev2.model.transform.RecognizeUtteranceRequestProtocolMarshaller;
import com.amazonaws.services.lexruntimev2.model.transform.RecognizeUtteranceResultJsonUnmarshaller;
import com.amazonaws.services.lexruntimev2.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.lexruntimev2.model.transform.ThrottlingExceptionUnmarshaller;
import com.amazonaws.services.lexruntimev2.model.transform.ValidationExceptionUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AmazonLexRuntimeV2Client
extends AmazonWebServiceClient
implements AmazonLexRuntimeV2 {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonLexRuntimeV2.class);
    private static final String DEFAULT_SIGNING_NAME = "lex";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AccessDeniedException").withExceptionUnmarshaller((JsonErrorUnmarshaller)AccessDeniedExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ValidationException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ValidationExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConflictException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ConflictExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("DependencyFailedException").withExceptionUnmarshaller((JsonErrorUnmarshaller)DependencyFailedExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InternalServerExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ThrottlingException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ThrottlingExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("BadGatewayException").withExceptionUnmarshaller((JsonErrorUnmarshaller)BadGatewayExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AmazonLexRuntimeV2Exception.class));

    public static AmazonLexRuntimeV2ClientBuilder builder() {
        return AmazonLexRuntimeV2ClientBuilder.standard();
    }

    AmazonLexRuntimeV2Client(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AmazonLexRuntimeV2Client(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix("runtime-v2-lex");
        this.setEndpoint("runtime-v2-lex.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/lexruntimev2/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/lexruntimev2/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public DeleteSessionResult deleteSession(DeleteSessionRequest request) {
        request = (DeleteSessionRequest)this.beforeClientExecution(request);
        return this.executeDeleteSession(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteSessionResult executeDeleteSession(DeleteSessionRequest deleteSessionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteSessionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteSessionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteSessionRequestProtocolMarshaller(protocolFactory).marshall((DeleteSessionRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteSessionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Lex Runtime V2");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteSession");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteSessionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteSessionResult deleteSessionResult = (DeleteSessionResult)response.getAwsResponse();
            return deleteSessionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetSessionResult getSession(GetSessionRequest request) {
        request = (GetSessionRequest)this.beforeClientExecution(request);
        return this.executeGetSession(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetSessionResult executeGetSession(GetSessionRequest getSessionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getSessionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetSessionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetSessionRequestProtocolMarshaller(protocolFactory).marshall((GetSessionRequest)super.beforeMarshalling((AmazonWebServiceRequest)getSessionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Lex Runtime V2");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetSession");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetSessionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetSessionResult getSessionResult = (GetSessionResult)response.getAwsResponse();
            return getSessionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PutSessionResult putSession(PutSessionRequest request) {
        request = (PutSessionRequest)this.beforeClientExecution(request);
        return this.executePutSession(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PutSessionResult executePutSession(PutSessionRequest putSessionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putSessionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutSessionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutSessionRequestProtocolMarshaller(protocolFactory).marshall((PutSessionRequest)super.beforeMarshalling((AmazonWebServiceRequest)putSessionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Lex Runtime V2");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"PutSession");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(false).withHasStreamingSuccessResponse(true), (Unmarshaller)new PutSessionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            request.addHandlerContext(HandlerContextKey.HAS_STREAMING_OUTPUT, (Object)Boolean.TRUE);
            PutSessionResult putSessionResult = (PutSessionResult)response.getAwsResponse();
            return putSessionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public RecognizeTextResult recognizeText(RecognizeTextRequest request) {
        request = (RecognizeTextRequest)this.beforeClientExecution(request);
        return this.executeRecognizeText(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final RecognizeTextResult executeRecognizeText(RecognizeTextRequest recognizeTextRequest) {
        ExecutionContext executionContext = this.createExecutionContext(recognizeTextRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<RecognizeTextRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new RecognizeTextRequestProtocolMarshaller(protocolFactory).marshall((RecognizeTextRequest)super.beforeMarshalling((AmazonWebServiceRequest)recognizeTextRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Lex Runtime V2");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"RecognizeText");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new RecognizeTextResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            RecognizeTextResult recognizeTextResult = (RecognizeTextResult)response.getAwsResponse();
            return recognizeTextResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public RecognizeUtteranceResult recognizeUtterance(RecognizeUtteranceRequest request) {
        request = (RecognizeUtteranceRequest)this.beforeClientExecution(request);
        return this.executeRecognizeUtterance(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final RecognizeUtteranceResult executeRecognizeUtterance(RecognizeUtteranceRequest recognizeUtteranceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(recognizeUtteranceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<RecognizeUtteranceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new RecognizeUtteranceRequestProtocolMarshaller(protocolFactory).marshall((RecognizeUtteranceRequest)super.beforeMarshalling((AmazonWebServiceRequest)recognizeUtteranceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Lex Runtime V2");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"RecognizeUtterance");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
                request.addHandlerContext(HandlerContextKey.HAS_STREAMING_INPUT, (Object)Boolean.TRUE);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(false).withHasStreamingSuccessResponse(true), (Unmarshaller)new RecognizeUtteranceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            request.addHandlerContext(HandlerContextKey.HAS_STREAMING_OUTPUT, (Object)Boolean.TRUE);
            RecognizeUtteranceResult recognizeUtteranceResult = (RecognizeUtteranceResult)response.getAwsResponse();
            return recognizeUtteranceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }
}

