/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lexmodelsv2.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.lexmodelsv2.model.SampleValue;
import com.amazonaws.services.lexmodelsv2.model.transform.SlotTypeValueMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SlotTypeValue
implements Serializable,
Cloneable,
StructuredPojo {
    private SampleValue sampleValue;
    private List<SampleValue> synonyms;

    public void setSampleValue(SampleValue sampleValue) {
        this.sampleValue = sampleValue;
    }

    public SampleValue getSampleValue() {
        return this.sampleValue;
    }

    public SlotTypeValue withSampleValue(SampleValue sampleValue) {
        this.setSampleValue(sampleValue);
        return this;
    }

    public List<SampleValue> getSynonyms() {
        return this.synonyms;
    }

    public void setSynonyms(Collection<SampleValue> synonyms) {
        if (synonyms == null) {
            this.synonyms = null;
            return;
        }
        this.synonyms = new ArrayList<SampleValue>(synonyms);
    }

    public SlotTypeValue withSynonyms(SampleValue ... synonyms) {
        if (this.synonyms == null) {
            this.setSynonyms(new ArrayList<SampleValue>(synonyms.length));
        }
        for (SampleValue ele : synonyms) {
            this.synonyms.add(ele);
        }
        return this;
    }

    public SlotTypeValue withSynonyms(Collection<SampleValue> synonyms) {
        this.setSynonyms(synonyms);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSampleValue() != null) {
            sb.append("SampleValue: ").append(this.getSampleValue()).append(",");
        }
        if (this.getSynonyms() != null) {
            sb.append("Synonyms: ").append(this.getSynonyms());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SlotTypeValue)) {
            return false;
        }
        SlotTypeValue other = (SlotTypeValue)obj;
        if (other.getSampleValue() == null ^ this.getSampleValue() == null) {
            return false;
        }
        if (other.getSampleValue() != null && !other.getSampleValue().equals(this.getSampleValue())) {
            return false;
        }
        if (other.getSynonyms() == null ^ this.getSynonyms() == null) {
            return false;
        }
        return other.getSynonyms() == null || other.getSynonyms().equals(this.getSynonyms());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSampleValue() == null ? 0 : this.getSampleValue().hashCode());
        hashCode = 31 * hashCode + (this.getSynonyms() == null ? 0 : this.getSynonyms().hashCode());
        return hashCode;
    }

    public SlotTypeValue clone() {
        try {
            return (SlotTypeValue)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SlotTypeValueMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

