/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lexmodelbuilding.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.lexmodelbuilding.model.CodeHook;
import com.amazonaws.services.lexmodelbuilding.model.FollowUpPrompt;
import com.amazonaws.services.lexmodelbuilding.model.FulfillmentActivity;
import com.amazonaws.services.lexmodelbuilding.model.Prompt;
import com.amazonaws.services.lexmodelbuilding.model.Slot;
import com.amazonaws.services.lexmodelbuilding.model.Statement;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PutIntentRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String name;
    private String description;
    private List<Slot> slots;
    private List<String> sampleUtterances;
    private Prompt confirmationPrompt;
    private Statement rejectionStatement;
    private FollowUpPrompt followUpPrompt;
    private Statement conclusionStatement;
    private CodeHook dialogCodeHook;
    private FulfillmentActivity fulfillmentActivity;
    private String parentIntentSignature;
    private String checksum;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public PutIntentRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public PutIntentRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public List<Slot> getSlots() {
        return this.slots;
    }

    public void setSlots(Collection<Slot> slots) {
        if (slots == null) {
            this.slots = null;
            return;
        }
        this.slots = new ArrayList<Slot>(slots);
    }

    public PutIntentRequest withSlots(Slot ... slots) {
        if (this.slots == null) {
            this.setSlots(new ArrayList<Slot>(slots.length));
        }
        for (Slot ele : slots) {
            this.slots.add(ele);
        }
        return this;
    }

    public PutIntentRequest withSlots(Collection<Slot> slots) {
        this.setSlots(slots);
        return this;
    }

    public List<String> getSampleUtterances() {
        return this.sampleUtterances;
    }

    public void setSampleUtterances(Collection<String> sampleUtterances) {
        if (sampleUtterances == null) {
            this.sampleUtterances = null;
            return;
        }
        this.sampleUtterances = new ArrayList<String>(sampleUtterances);
    }

    public PutIntentRequest withSampleUtterances(String ... sampleUtterances) {
        if (this.sampleUtterances == null) {
            this.setSampleUtterances(new ArrayList<String>(sampleUtterances.length));
        }
        for (String ele : sampleUtterances) {
            this.sampleUtterances.add(ele);
        }
        return this;
    }

    public PutIntentRequest withSampleUtterances(Collection<String> sampleUtterances) {
        this.setSampleUtterances(sampleUtterances);
        return this;
    }

    public void setConfirmationPrompt(Prompt confirmationPrompt) {
        this.confirmationPrompt = confirmationPrompt;
    }

    public Prompt getConfirmationPrompt() {
        return this.confirmationPrompt;
    }

    public PutIntentRequest withConfirmationPrompt(Prompt confirmationPrompt) {
        this.setConfirmationPrompt(confirmationPrompt);
        return this;
    }

    public void setRejectionStatement(Statement rejectionStatement) {
        this.rejectionStatement = rejectionStatement;
    }

    public Statement getRejectionStatement() {
        return this.rejectionStatement;
    }

    public PutIntentRequest withRejectionStatement(Statement rejectionStatement) {
        this.setRejectionStatement(rejectionStatement);
        return this;
    }

    public void setFollowUpPrompt(FollowUpPrompt followUpPrompt) {
        this.followUpPrompt = followUpPrompt;
    }

    public FollowUpPrompt getFollowUpPrompt() {
        return this.followUpPrompt;
    }

    public PutIntentRequest withFollowUpPrompt(FollowUpPrompt followUpPrompt) {
        this.setFollowUpPrompt(followUpPrompt);
        return this;
    }

    public void setConclusionStatement(Statement conclusionStatement) {
        this.conclusionStatement = conclusionStatement;
    }

    public Statement getConclusionStatement() {
        return this.conclusionStatement;
    }

    public PutIntentRequest withConclusionStatement(Statement conclusionStatement) {
        this.setConclusionStatement(conclusionStatement);
        return this;
    }

    public void setDialogCodeHook(CodeHook dialogCodeHook) {
        this.dialogCodeHook = dialogCodeHook;
    }

    public CodeHook getDialogCodeHook() {
        return this.dialogCodeHook;
    }

    public PutIntentRequest withDialogCodeHook(CodeHook dialogCodeHook) {
        this.setDialogCodeHook(dialogCodeHook);
        return this;
    }

    public void setFulfillmentActivity(FulfillmentActivity fulfillmentActivity) {
        this.fulfillmentActivity = fulfillmentActivity;
    }

    public FulfillmentActivity getFulfillmentActivity() {
        return this.fulfillmentActivity;
    }

    public PutIntentRequest withFulfillmentActivity(FulfillmentActivity fulfillmentActivity) {
        this.setFulfillmentActivity(fulfillmentActivity);
        return this;
    }

    public void setParentIntentSignature(String parentIntentSignature) {
        this.parentIntentSignature = parentIntentSignature;
    }

    public String getParentIntentSignature() {
        return this.parentIntentSignature;
    }

    public PutIntentRequest withParentIntentSignature(String parentIntentSignature) {
        this.setParentIntentSignature(parentIntentSignature);
        return this;
    }

    public void setChecksum(String checksum) {
        this.checksum = checksum;
    }

    public String getChecksum() {
        return this.checksum;
    }

    public PutIntentRequest withChecksum(String checksum) {
        this.setChecksum(checksum);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getSlots() != null) {
            sb.append("Slots: ").append(this.getSlots()).append(",");
        }
        if (this.getSampleUtterances() != null) {
            sb.append("SampleUtterances: ").append(this.getSampleUtterances()).append(",");
        }
        if (this.getConfirmationPrompt() != null) {
            sb.append("ConfirmationPrompt: ").append(this.getConfirmationPrompt()).append(",");
        }
        if (this.getRejectionStatement() != null) {
            sb.append("RejectionStatement: ").append(this.getRejectionStatement()).append(",");
        }
        if (this.getFollowUpPrompt() != null) {
            sb.append("FollowUpPrompt: ").append(this.getFollowUpPrompt()).append(",");
        }
        if (this.getConclusionStatement() != null) {
            sb.append("ConclusionStatement: ").append(this.getConclusionStatement()).append(",");
        }
        if (this.getDialogCodeHook() != null) {
            sb.append("DialogCodeHook: ").append(this.getDialogCodeHook()).append(",");
        }
        if (this.getFulfillmentActivity() != null) {
            sb.append("FulfillmentActivity: ").append(this.getFulfillmentActivity()).append(",");
        }
        if (this.getParentIntentSignature() != null) {
            sb.append("ParentIntentSignature: ").append(this.getParentIntentSignature()).append(",");
        }
        if (this.getChecksum() != null) {
            sb.append("Checksum: ").append(this.getChecksum());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutIntentRequest)) {
            return false;
        }
        PutIntentRequest other = (PutIntentRequest)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getSlots() == null ^ this.getSlots() == null) {
            return false;
        }
        if (other.getSlots() != null && !other.getSlots().equals(this.getSlots())) {
            return false;
        }
        if (other.getSampleUtterances() == null ^ this.getSampleUtterances() == null) {
            return false;
        }
        if (other.getSampleUtterances() != null && !other.getSampleUtterances().equals(this.getSampleUtterances())) {
            return false;
        }
        if (other.getConfirmationPrompt() == null ^ this.getConfirmationPrompt() == null) {
            return false;
        }
        if (other.getConfirmationPrompt() != null && !other.getConfirmationPrompt().equals(this.getConfirmationPrompt())) {
            return false;
        }
        if (other.getRejectionStatement() == null ^ this.getRejectionStatement() == null) {
            return false;
        }
        if (other.getRejectionStatement() != null && !other.getRejectionStatement().equals(this.getRejectionStatement())) {
            return false;
        }
        if (other.getFollowUpPrompt() == null ^ this.getFollowUpPrompt() == null) {
            return false;
        }
        if (other.getFollowUpPrompt() != null && !other.getFollowUpPrompt().equals(this.getFollowUpPrompt())) {
            return false;
        }
        if (other.getConclusionStatement() == null ^ this.getConclusionStatement() == null) {
            return false;
        }
        if (other.getConclusionStatement() != null && !other.getConclusionStatement().equals(this.getConclusionStatement())) {
            return false;
        }
        if (other.getDialogCodeHook() == null ^ this.getDialogCodeHook() == null) {
            return false;
        }
        if (other.getDialogCodeHook() != null && !other.getDialogCodeHook().equals(this.getDialogCodeHook())) {
            return false;
        }
        if (other.getFulfillmentActivity() == null ^ this.getFulfillmentActivity() == null) {
            return false;
        }
        if (other.getFulfillmentActivity() != null && !other.getFulfillmentActivity().equals(this.getFulfillmentActivity())) {
            return false;
        }
        if (other.getParentIntentSignature() == null ^ this.getParentIntentSignature() == null) {
            return false;
        }
        if (other.getParentIntentSignature() != null && !other.getParentIntentSignature().equals(this.getParentIntentSignature())) {
            return false;
        }
        if (other.getChecksum() == null ^ this.getChecksum() == null) {
            return false;
        }
        return other.getChecksum() == null || other.getChecksum().equals(this.getChecksum());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getSlots() == null ? 0 : this.getSlots().hashCode());
        hashCode = 31 * hashCode + (this.getSampleUtterances() == null ? 0 : this.getSampleUtterances().hashCode());
        hashCode = 31 * hashCode + (this.getConfirmationPrompt() == null ? 0 : this.getConfirmationPrompt().hashCode());
        hashCode = 31 * hashCode + (this.getRejectionStatement() == null ? 0 : this.getRejectionStatement().hashCode());
        hashCode = 31 * hashCode + (this.getFollowUpPrompt() == null ? 0 : this.getFollowUpPrompt().hashCode());
        hashCode = 31 * hashCode + (this.getConclusionStatement() == null ? 0 : this.getConclusionStatement().hashCode());
        hashCode = 31 * hashCode + (this.getDialogCodeHook() == null ? 0 : this.getDialogCodeHook().hashCode());
        hashCode = 31 * hashCode + (this.getFulfillmentActivity() == null ? 0 : this.getFulfillmentActivity().hashCode());
        hashCode = 31 * hashCode + (this.getParentIntentSignature() == null ? 0 : this.getParentIntentSignature().hashCode());
        hashCode = 31 * hashCode + (this.getChecksum() == null ? 0 : this.getChecksum().hashCode());
        return hashCode;
    }

    public PutIntentRequest clone() {
        return (PutIntentRequest)super.clone();
    }
}

