/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lexruntime.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.lexruntime.model.ActiveContext;
import com.amazonaws.services.lexruntime.model.DialogAction;
import com.amazonaws.services.lexruntime.model.IntentSummary;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GetSessionResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<IntentSummary> recentIntentSummaryView;
    private Map<String, String> sessionAttributes;
    private String sessionId;
    private DialogAction dialogAction;
    private List<ActiveContext> activeContexts;

    public List<IntentSummary> getRecentIntentSummaryView() {
        return this.recentIntentSummaryView;
    }

    public void setRecentIntentSummaryView(Collection<IntentSummary> recentIntentSummaryView) {
        if (recentIntentSummaryView == null) {
            this.recentIntentSummaryView = null;
            return;
        }
        this.recentIntentSummaryView = new ArrayList<IntentSummary>(recentIntentSummaryView);
    }

    public GetSessionResult withRecentIntentSummaryView(IntentSummary ... recentIntentSummaryView) {
        if (this.recentIntentSummaryView == null) {
            this.setRecentIntentSummaryView(new ArrayList<IntentSummary>(recentIntentSummaryView.length));
        }
        for (IntentSummary ele : recentIntentSummaryView) {
            this.recentIntentSummaryView.add(ele);
        }
        return this;
    }

    public GetSessionResult withRecentIntentSummaryView(Collection<IntentSummary> recentIntentSummaryView) {
        this.setRecentIntentSummaryView(recentIntentSummaryView);
        return this;
    }

    public Map<String, String> getSessionAttributes() {
        return this.sessionAttributes;
    }

    public void setSessionAttributes(Map<String, String> sessionAttributes) {
        this.sessionAttributes = sessionAttributes;
    }

    public GetSessionResult withSessionAttributes(Map<String, String> sessionAttributes) {
        this.setSessionAttributes(sessionAttributes);
        return this;
    }

    public GetSessionResult addSessionAttributesEntry(String key, String value) {
        if (null == this.sessionAttributes) {
            this.sessionAttributes = new HashMap<String, String>();
        }
        if (this.sessionAttributes.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.sessionAttributes.put(key, value);
        return this;
    }

    public GetSessionResult clearSessionAttributesEntries() {
        this.sessionAttributes = null;
        return this;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public GetSessionResult withSessionId(String sessionId) {
        this.setSessionId(sessionId);
        return this;
    }

    public void setDialogAction(DialogAction dialogAction) {
        this.dialogAction = dialogAction;
    }

    public DialogAction getDialogAction() {
        return this.dialogAction;
    }

    public GetSessionResult withDialogAction(DialogAction dialogAction) {
        this.setDialogAction(dialogAction);
        return this;
    }

    public List<ActiveContext> getActiveContexts() {
        return this.activeContexts;
    }

    public void setActiveContexts(Collection<ActiveContext> activeContexts) {
        if (activeContexts == null) {
            this.activeContexts = null;
            return;
        }
        this.activeContexts = new ArrayList<ActiveContext>(activeContexts);
    }

    public GetSessionResult withActiveContexts(ActiveContext ... activeContexts) {
        if (this.activeContexts == null) {
            this.setActiveContexts(new ArrayList<ActiveContext>(activeContexts.length));
        }
        for (ActiveContext ele : activeContexts) {
            this.activeContexts.add(ele);
        }
        return this;
    }

    public GetSessionResult withActiveContexts(Collection<ActiveContext> activeContexts) {
        this.setActiveContexts(activeContexts);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getRecentIntentSummaryView() != null) {
            sb.append("RecentIntentSummaryView: ").append(this.getRecentIntentSummaryView()).append(",");
        }
        if (this.getSessionAttributes() != null) {
            sb.append("SessionAttributes: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getSessionId() != null) {
            sb.append("SessionId: ").append(this.getSessionId()).append(",");
        }
        if (this.getDialogAction() != null) {
            sb.append("DialogAction: ").append(this.getDialogAction()).append(",");
        }
        if (this.getActiveContexts() != null) {
            sb.append("ActiveContexts: ").append("***Sensitive Data Redacted***");
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSessionResult)) {
            return false;
        }
        GetSessionResult other = (GetSessionResult)obj;
        if (other.getRecentIntentSummaryView() == null ^ this.getRecentIntentSummaryView() == null) {
            return false;
        }
        if (other.getRecentIntentSummaryView() != null && !other.getRecentIntentSummaryView().equals(this.getRecentIntentSummaryView())) {
            return false;
        }
        if (other.getSessionAttributes() == null ^ this.getSessionAttributes() == null) {
            return false;
        }
        if (other.getSessionAttributes() != null && !other.getSessionAttributes().equals(this.getSessionAttributes())) {
            return false;
        }
        if (other.getSessionId() == null ^ this.getSessionId() == null) {
            return false;
        }
        if (other.getSessionId() != null && !other.getSessionId().equals(this.getSessionId())) {
            return false;
        }
        if (other.getDialogAction() == null ^ this.getDialogAction() == null) {
            return false;
        }
        if (other.getDialogAction() != null && !other.getDialogAction().equals(this.getDialogAction())) {
            return false;
        }
        if (other.getActiveContexts() == null ^ this.getActiveContexts() == null) {
            return false;
        }
        return other.getActiveContexts() == null || other.getActiveContexts().equals(this.getActiveContexts());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getRecentIntentSummaryView() == null ? 0 : this.getRecentIntentSummaryView().hashCode());
        hashCode = 31 * hashCode + (this.getSessionAttributes() == null ? 0 : this.getSessionAttributes().hashCode());
        hashCode = 31 * hashCode + (this.getSessionId() == null ? 0 : this.getSessionId().hashCode());
        hashCode = 31 * hashCode + (this.getDialogAction() == null ? 0 : this.getDialogAction().hashCode());
        hashCode = 31 * hashCode + (this.getActiveContexts() == null ? 0 : this.getActiveContexts().hashCode());
        return hashCode;
    }

    public GetSessionResult clone() {
        try {
            return (GetSessionResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

