/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lakeformation.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.lakeformation.model.EnableStatus;
import com.amazonaws.services.lakeformation.model.transform.ExternalFilteringConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ExternalFilteringConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private String status;
    private List<String> authorizedTargets;

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public ExternalFilteringConfiguration withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public ExternalFilteringConfiguration withStatus(EnableStatus status) {
        this.status = status.toString();
        return this;
    }

    public List<String> getAuthorizedTargets() {
        return this.authorizedTargets;
    }

    public void setAuthorizedTargets(Collection<String> authorizedTargets) {
        if (authorizedTargets == null) {
            this.authorizedTargets = null;
            return;
        }
        this.authorizedTargets = new ArrayList<String>(authorizedTargets);
    }

    public ExternalFilteringConfiguration withAuthorizedTargets(String ... authorizedTargets) {
        if (this.authorizedTargets == null) {
            this.setAuthorizedTargets(new ArrayList<String>(authorizedTargets.length));
        }
        for (String ele : authorizedTargets) {
            this.authorizedTargets.add(ele);
        }
        return this;
    }

    public ExternalFilteringConfiguration withAuthorizedTargets(Collection<String> authorizedTargets) {
        this.setAuthorizedTargets(authorizedTargets);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getAuthorizedTargets() != null) {
            sb.append("AuthorizedTargets: ").append(this.getAuthorizedTargets());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExternalFilteringConfiguration)) {
            return false;
        }
        ExternalFilteringConfiguration other = (ExternalFilteringConfiguration)obj;
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getAuthorizedTargets() == null ^ this.getAuthorizedTargets() == null) {
            return false;
        }
        return other.getAuthorizedTargets() == null || other.getAuthorizedTargets().equals(this.getAuthorizedTargets());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getAuthorizedTargets() == null ? 0 : this.getAuthorizedTargets().hashCode());
        return hashCode;
    }

    public ExternalFilteringConfiguration clone() {
        try {
            return (ExternalFilteringConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ExternalFilteringConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

