/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisvideo.model;

public final class AckEventType {
    private final Values enumValue;
    private final String rawValue;

    private AckEventType(Values enumValue, String rawValue) {
        this.enumValue = enumValue;
        this.rawValue = rawValue;
    }

    public static AckEventType of(String value) {
        return value == null ? null : new AckEventType(Values.fromValue(value), value);
    }

    public static AckEventType of(Values value) {
        if (value == Values.SDK_UNKNOWN) {
            throw new IllegalArgumentException("SDK_UNKNOWN cannot be used to create an AckEventType. Use the raw value tocreate an AckEventType from a string instead");
        }
        return value == null ? null : new AckEventType(value, value.toString());
    }

    public String getRawValue() {
        return this.rawValue;
    }

    public Values getEnumValue() {
        return this.enumValue;
    }

    public String toString() {
        return this.rawValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AckEventType that = (AckEventType)o;
        return this.rawValue != null ? this.rawValue.equals(that.rawValue) : that.rawValue == null;
    }

    public int hashCode() {
        return this.rawValue != null ? this.rawValue.hashCode() : 0;
    }

    public static enum Values {
        BUFFERING("BUFFERING"),
        RECEIVED("RECEIVED"),
        PERSISTED("PERSISTED"),
        ERROR("ERROR"),
        IDLE("IDLE"),
        SDK_UNKNOWN(null);

        private final String value;

        private Values(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        private static Values fromValue(String value) {
            if (value == null || "".equals(value)) {
                throw new IllegalArgumentException("Value cannot be null or empty!");
            }
            for (Values enumEntry : Values.values()) {
                if (!value.equals(enumEntry.toString())) continue;
                return enumEntry;
            }
            return SDK_UNKNOWN;
        }
    }
}

