/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.keyspaces.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.keyspaces.model.KeyspaceSummary;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListKeyspacesResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String nextToken;
    private List<KeyspaceSummary> keyspaces;

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListKeyspacesResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public List<KeyspaceSummary> getKeyspaces() {
        return this.keyspaces;
    }

    public void setKeyspaces(Collection<KeyspaceSummary> keyspaces) {
        if (keyspaces == null) {
            this.keyspaces = null;
            return;
        }
        this.keyspaces = new ArrayList<KeyspaceSummary>(keyspaces);
    }

    public ListKeyspacesResult withKeyspaces(KeyspaceSummary ... keyspaces) {
        if (this.keyspaces == null) {
            this.setKeyspaces(new ArrayList<KeyspaceSummary>(keyspaces.length));
        }
        for (KeyspaceSummary ele : keyspaces) {
            this.keyspaces.add(ele);
        }
        return this;
    }

    public ListKeyspacesResult withKeyspaces(Collection<KeyspaceSummary> keyspaces) {
        this.setKeyspaces(keyspaces);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getKeyspaces() != null) {
            sb.append("Keyspaces: ").append(this.getKeyspaces());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListKeyspacesResult)) {
            return false;
        }
        ListKeyspacesResult other = (ListKeyspacesResult)obj;
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getKeyspaces() == null ^ this.getKeyspaces() == null) {
            return false;
        }
        return other.getKeyspaces() == null || other.getKeyspaces().equals(this.getKeyspaces());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getKeyspaces() == null ? 0 : this.getKeyspaces().hashCode());
        return hashCode;
    }

    public ListKeyspacesResult clone() {
        try {
            return (ListKeyspacesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

