/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.keyspaces.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.keyspaces.model.Rs;
import com.amazonaws.services.keyspaces.model.transform.ReplicationSpecificationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ReplicationSpecification
implements Serializable,
Cloneable,
StructuredPojo {
    private String replicationStrategy;
    private List<String> regionList;

    public void setReplicationStrategy(String replicationStrategy) {
        this.replicationStrategy = replicationStrategy;
    }

    public String getReplicationStrategy() {
        return this.replicationStrategy;
    }

    public ReplicationSpecification withReplicationStrategy(String replicationStrategy) {
        this.setReplicationStrategy(replicationStrategy);
        return this;
    }

    public ReplicationSpecification withReplicationStrategy(Rs replicationStrategy) {
        this.replicationStrategy = replicationStrategy.toString();
        return this;
    }

    public List<String> getRegionList() {
        return this.regionList;
    }

    public void setRegionList(Collection<String> regionList) {
        if (regionList == null) {
            this.regionList = null;
            return;
        }
        this.regionList = new ArrayList<String>(regionList);
    }

    public ReplicationSpecification withRegionList(String ... regionList) {
        if (this.regionList == null) {
            this.setRegionList(new ArrayList<String>(regionList.length));
        }
        for (String ele : regionList) {
            this.regionList.add(ele);
        }
        return this;
    }

    public ReplicationSpecification withRegionList(Collection<String> regionList) {
        this.setRegionList(regionList);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getReplicationStrategy() != null) {
            sb.append("ReplicationStrategy: ").append(this.getReplicationStrategy()).append(",");
        }
        if (this.getRegionList() != null) {
            sb.append("RegionList: ").append(this.getRegionList());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicationSpecification)) {
            return false;
        }
        ReplicationSpecification other = (ReplicationSpecification)obj;
        if (other.getReplicationStrategy() == null ^ this.getReplicationStrategy() == null) {
            return false;
        }
        if (other.getReplicationStrategy() != null && !other.getReplicationStrategy().equals(this.getReplicationStrategy())) {
            return false;
        }
        if (other.getRegionList() == null ^ this.getRegionList() == null) {
            return false;
        }
        return other.getRegionList() == null || other.getRegionList().equals(this.getRegionList());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getReplicationStrategy() == null ? 0 : this.getReplicationStrategy().hashCode());
        hashCode = 31 * hashCode + (this.getRegionList() == null ? 0 : this.getRegionList().hashCode());
        return hashCode;
    }

    public ReplicationSpecification clone() {
        try {
            return (ReplicationSpecification)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ReplicationSpecificationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

