/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.keyspaces.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.keyspaces.model.ClusteringKey;
import com.amazonaws.services.keyspaces.model.ColumnDefinition;
import com.amazonaws.services.keyspaces.model.PartitionKey;
import com.amazonaws.services.keyspaces.model.StaticColumn;
import com.amazonaws.services.keyspaces.model.transform.SchemaDefinitionMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SchemaDefinition
implements Serializable,
Cloneable,
StructuredPojo {
    private List<ColumnDefinition> allColumns;
    private List<PartitionKey> partitionKeys;
    private List<ClusteringKey> clusteringKeys;
    private List<StaticColumn> staticColumns;

    public List<ColumnDefinition> getAllColumns() {
        return this.allColumns;
    }

    public void setAllColumns(Collection<ColumnDefinition> allColumns) {
        if (allColumns == null) {
            this.allColumns = null;
            return;
        }
        this.allColumns = new ArrayList<ColumnDefinition>(allColumns);
    }

    public SchemaDefinition withAllColumns(ColumnDefinition ... allColumns) {
        if (this.allColumns == null) {
            this.setAllColumns(new ArrayList<ColumnDefinition>(allColumns.length));
        }
        for (ColumnDefinition ele : allColumns) {
            this.allColumns.add(ele);
        }
        return this;
    }

    public SchemaDefinition withAllColumns(Collection<ColumnDefinition> allColumns) {
        this.setAllColumns(allColumns);
        return this;
    }

    public List<PartitionKey> getPartitionKeys() {
        return this.partitionKeys;
    }

    public void setPartitionKeys(Collection<PartitionKey> partitionKeys) {
        if (partitionKeys == null) {
            this.partitionKeys = null;
            return;
        }
        this.partitionKeys = new ArrayList<PartitionKey>(partitionKeys);
    }

    public SchemaDefinition withPartitionKeys(PartitionKey ... partitionKeys) {
        if (this.partitionKeys == null) {
            this.setPartitionKeys(new ArrayList<PartitionKey>(partitionKeys.length));
        }
        for (PartitionKey ele : partitionKeys) {
            this.partitionKeys.add(ele);
        }
        return this;
    }

    public SchemaDefinition withPartitionKeys(Collection<PartitionKey> partitionKeys) {
        this.setPartitionKeys(partitionKeys);
        return this;
    }

    public List<ClusteringKey> getClusteringKeys() {
        return this.clusteringKeys;
    }

    public void setClusteringKeys(Collection<ClusteringKey> clusteringKeys) {
        if (clusteringKeys == null) {
            this.clusteringKeys = null;
            return;
        }
        this.clusteringKeys = new ArrayList<ClusteringKey>(clusteringKeys);
    }

    public SchemaDefinition withClusteringKeys(ClusteringKey ... clusteringKeys) {
        if (this.clusteringKeys == null) {
            this.setClusteringKeys(new ArrayList<ClusteringKey>(clusteringKeys.length));
        }
        for (ClusteringKey ele : clusteringKeys) {
            this.clusteringKeys.add(ele);
        }
        return this;
    }

    public SchemaDefinition withClusteringKeys(Collection<ClusteringKey> clusteringKeys) {
        this.setClusteringKeys(clusteringKeys);
        return this;
    }

    public List<StaticColumn> getStaticColumns() {
        return this.staticColumns;
    }

    public void setStaticColumns(Collection<StaticColumn> staticColumns) {
        if (staticColumns == null) {
            this.staticColumns = null;
            return;
        }
        this.staticColumns = new ArrayList<StaticColumn>(staticColumns);
    }

    public SchemaDefinition withStaticColumns(StaticColumn ... staticColumns) {
        if (this.staticColumns == null) {
            this.setStaticColumns(new ArrayList<StaticColumn>(staticColumns.length));
        }
        for (StaticColumn ele : staticColumns) {
            this.staticColumns.add(ele);
        }
        return this;
    }

    public SchemaDefinition withStaticColumns(Collection<StaticColumn> staticColumns) {
        this.setStaticColumns(staticColumns);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAllColumns() != null) {
            sb.append("AllColumns: ").append(this.getAllColumns()).append(",");
        }
        if (this.getPartitionKeys() != null) {
            sb.append("PartitionKeys: ").append(this.getPartitionKeys()).append(",");
        }
        if (this.getClusteringKeys() != null) {
            sb.append("ClusteringKeys: ").append(this.getClusteringKeys()).append(",");
        }
        if (this.getStaticColumns() != null) {
            sb.append("StaticColumns: ").append(this.getStaticColumns());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SchemaDefinition)) {
            return false;
        }
        SchemaDefinition other = (SchemaDefinition)obj;
        if (other.getAllColumns() == null ^ this.getAllColumns() == null) {
            return false;
        }
        if (other.getAllColumns() != null && !other.getAllColumns().equals(this.getAllColumns())) {
            return false;
        }
        if (other.getPartitionKeys() == null ^ this.getPartitionKeys() == null) {
            return false;
        }
        if (other.getPartitionKeys() != null && !other.getPartitionKeys().equals(this.getPartitionKeys())) {
            return false;
        }
        if (other.getClusteringKeys() == null ^ this.getClusteringKeys() == null) {
            return false;
        }
        if (other.getClusteringKeys() != null && !other.getClusteringKeys().equals(this.getClusteringKeys())) {
            return false;
        }
        if (other.getStaticColumns() == null ^ this.getStaticColumns() == null) {
            return false;
        }
        return other.getStaticColumns() == null || other.getStaticColumns().equals(this.getStaticColumns());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAllColumns() == null ? 0 : this.getAllColumns().hashCode());
        hashCode = 31 * hashCode + (this.getPartitionKeys() == null ? 0 : this.getPartitionKeys().hashCode());
        hashCode = 31 * hashCode + (this.getClusteringKeys() == null ? 0 : this.getClusteringKeys().hashCode());
        hashCode = 31 * hashCode + (this.getStaticColumns() == null ? 0 : this.getStaticColumns().hashCode());
        return hashCode;
    }

    public SchemaDefinition clone() {
        try {
            return (SchemaDefinition)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SchemaDefinitionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

