/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kafkaconnect.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.kafkaconnect.model.Vpc;
import java.util.List;

@SdkInternalApi
public class VpcMarshaller {
    private static final MarshallingInfo<List> SECURITYGROUPS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("securityGroups").build();
    private static final MarshallingInfo<List> SUBNETS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("subnets").build();
    private static final VpcMarshaller instance = new VpcMarshaller();

    public static VpcMarshaller getInstance() {
        return instance;
    }

    public void marshall(Vpc vpc, ProtocolMarshaller protocolMarshaller) {
        if (vpc == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(vpc.getSecurityGroups(), SECURITYGROUPS_BINDING);
            protocolMarshaller.marshall(vpc.getSubnets(), SUBNETS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

