/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kafka.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.kafka.model.Prometheus;

@SdkInternalApi
public class PrometheusMarshaller {
    private static final MarshallingInfo<StructuredPojo> JMXEXPORTER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("jmxExporter").build();
    private static final MarshallingInfo<StructuredPojo> NODEEXPORTER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("nodeExporter").build();
    private static final PrometheusMarshaller instance = new PrometheusMarshaller();

    public static PrometheusMarshaller getInstance() {
        return instance;
    }

    public void marshall(Prometheus prometheus, ProtocolMarshaller protocolMarshaller) {
        if (prometheus == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)prometheus.getJmxExporter(), JMXEXPORTER_BINDING);
            protocolMarshaller.marshall((Object)prometheus.getNodeExporter(), NODEEXPORTER_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

