/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iotwireless.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.iotwireless.model.ApplicationConfig;
import com.amazonaws.services.iotwireless.model.Positioning;
import com.amazonaws.services.iotwireless.model.transform.UpdateFPortsMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UpdateFPorts
implements Serializable,
Cloneable,
StructuredPojo {
    private Positioning positioning;
    private List<ApplicationConfig> applications;

    public void setPositioning(Positioning positioning) {
        this.positioning = positioning;
    }

    public Positioning getPositioning() {
        return this.positioning;
    }

    public UpdateFPorts withPositioning(Positioning positioning) {
        this.setPositioning(positioning);
        return this;
    }

    public List<ApplicationConfig> getApplications() {
        return this.applications;
    }

    public void setApplications(Collection<ApplicationConfig> applications) {
        if (applications == null) {
            this.applications = null;
            return;
        }
        this.applications = new ArrayList<ApplicationConfig>(applications);
    }

    public UpdateFPorts withApplications(ApplicationConfig ... applications) {
        if (this.applications == null) {
            this.setApplications(new ArrayList<ApplicationConfig>(applications.length));
        }
        for (ApplicationConfig ele : applications) {
            this.applications.add(ele);
        }
        return this;
    }

    public UpdateFPorts withApplications(Collection<ApplicationConfig> applications) {
        this.setApplications(applications);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPositioning() != null) {
            sb.append("Positioning: ").append(this.getPositioning()).append(",");
        }
        if (this.getApplications() != null) {
            sb.append("Applications: ").append(this.getApplications());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFPorts)) {
            return false;
        }
        UpdateFPorts other = (UpdateFPorts)obj;
        if (other.getPositioning() == null ^ this.getPositioning() == null) {
            return false;
        }
        if (other.getPositioning() != null && !other.getPositioning().equals(this.getPositioning())) {
            return false;
        }
        if (other.getApplications() == null ^ this.getApplications() == null) {
            return false;
        }
        return other.getApplications() == null || other.getApplications().equals(this.getApplications());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPositioning() == null ? 0 : this.getPositioning().hashCode());
        hashCode = 31 * hashCode + (this.getApplications() == null ? 0 : this.getApplications().hashCode());
        return hashCode;
    }

    public UpdateFPorts clone() {
        try {
            return (UpdateFPorts)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        UpdateFPortsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

