/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iottwinmaker.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.iottwinmaker.model.ComponentUpdateRequest;
import com.amazonaws.services.iottwinmaker.model.CompositeComponentUpdateRequest;
import com.amazonaws.services.iottwinmaker.model.ParentEntityUpdateRequest;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class UpdateEntityRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String workspaceId;
    private String entityId;
    private String entityName;
    private String description;
    private Map<String, ComponentUpdateRequest> componentUpdates;
    private Map<String, CompositeComponentUpdateRequest> compositeComponentUpdates;
    private ParentEntityUpdateRequest parentEntityUpdate;

    public void setWorkspaceId(String workspaceId) {
        this.workspaceId = workspaceId;
    }

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public UpdateEntityRequest withWorkspaceId(String workspaceId) {
        this.setWorkspaceId(workspaceId);
        return this;
    }

    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public UpdateEntityRequest withEntityId(String entityId) {
        this.setEntityId(entityId);
        return this;
    }

    public void setEntityName(String entityName) {
        this.entityName = entityName;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public UpdateEntityRequest withEntityName(String entityName) {
        this.setEntityName(entityName);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public UpdateEntityRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public Map<String, ComponentUpdateRequest> getComponentUpdates() {
        return this.componentUpdates;
    }

    public void setComponentUpdates(Map<String, ComponentUpdateRequest> componentUpdates) {
        this.componentUpdates = componentUpdates;
    }

    public UpdateEntityRequest withComponentUpdates(Map<String, ComponentUpdateRequest> componentUpdates) {
        this.setComponentUpdates(componentUpdates);
        return this;
    }

    public UpdateEntityRequest addComponentUpdatesEntry(String key, ComponentUpdateRequest value) {
        if (null == this.componentUpdates) {
            this.componentUpdates = new HashMap<String, ComponentUpdateRequest>();
        }
        if (this.componentUpdates.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.componentUpdates.put(key, value);
        return this;
    }

    public UpdateEntityRequest clearComponentUpdatesEntries() {
        this.componentUpdates = null;
        return this;
    }

    public Map<String, CompositeComponentUpdateRequest> getCompositeComponentUpdates() {
        return this.compositeComponentUpdates;
    }

    public void setCompositeComponentUpdates(Map<String, CompositeComponentUpdateRequest> compositeComponentUpdates) {
        this.compositeComponentUpdates = compositeComponentUpdates;
    }

    public UpdateEntityRequest withCompositeComponentUpdates(Map<String, CompositeComponentUpdateRequest> compositeComponentUpdates) {
        this.setCompositeComponentUpdates(compositeComponentUpdates);
        return this;
    }

    public UpdateEntityRequest addCompositeComponentUpdatesEntry(String key, CompositeComponentUpdateRequest value) {
        if (null == this.compositeComponentUpdates) {
            this.compositeComponentUpdates = new HashMap<String, CompositeComponentUpdateRequest>();
        }
        if (this.compositeComponentUpdates.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.compositeComponentUpdates.put(key, value);
        return this;
    }

    public UpdateEntityRequest clearCompositeComponentUpdatesEntries() {
        this.compositeComponentUpdates = null;
        return this;
    }

    public void setParentEntityUpdate(ParentEntityUpdateRequest parentEntityUpdate) {
        this.parentEntityUpdate = parentEntityUpdate;
    }

    public ParentEntityUpdateRequest getParentEntityUpdate() {
        return this.parentEntityUpdate;
    }

    public UpdateEntityRequest withParentEntityUpdate(ParentEntityUpdateRequest parentEntityUpdate) {
        this.setParentEntityUpdate(parentEntityUpdate);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getWorkspaceId() != null) {
            sb.append("WorkspaceId: ").append(this.getWorkspaceId()).append(",");
        }
        if (this.getEntityId() != null) {
            sb.append("EntityId: ").append(this.getEntityId()).append(",");
        }
        if (this.getEntityName() != null) {
            sb.append("EntityName: ").append(this.getEntityName()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getComponentUpdates() != null) {
            sb.append("ComponentUpdates: ").append(this.getComponentUpdates()).append(",");
        }
        if (this.getCompositeComponentUpdates() != null) {
            sb.append("CompositeComponentUpdates: ").append(this.getCompositeComponentUpdates()).append(",");
        }
        if (this.getParentEntityUpdate() != null) {
            sb.append("ParentEntityUpdate: ").append(this.getParentEntityUpdate());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateEntityRequest)) {
            return false;
        }
        UpdateEntityRequest other = (UpdateEntityRequest)obj;
        if (other.getWorkspaceId() == null ^ this.getWorkspaceId() == null) {
            return false;
        }
        if (other.getWorkspaceId() != null && !other.getWorkspaceId().equals(this.getWorkspaceId())) {
            return false;
        }
        if (other.getEntityId() == null ^ this.getEntityId() == null) {
            return false;
        }
        if (other.getEntityId() != null && !other.getEntityId().equals(this.getEntityId())) {
            return false;
        }
        if (other.getEntityName() == null ^ this.getEntityName() == null) {
            return false;
        }
        if (other.getEntityName() != null && !other.getEntityName().equals(this.getEntityName())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getComponentUpdates() == null ^ this.getComponentUpdates() == null) {
            return false;
        }
        if (other.getComponentUpdates() != null && !other.getComponentUpdates().equals(this.getComponentUpdates())) {
            return false;
        }
        if (other.getCompositeComponentUpdates() == null ^ this.getCompositeComponentUpdates() == null) {
            return false;
        }
        if (other.getCompositeComponentUpdates() != null && !other.getCompositeComponentUpdates().equals(this.getCompositeComponentUpdates())) {
            return false;
        }
        if (other.getParentEntityUpdate() == null ^ this.getParentEntityUpdate() == null) {
            return false;
        }
        return other.getParentEntityUpdate() == null || other.getParentEntityUpdate().equals(this.getParentEntityUpdate());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getWorkspaceId() == null ? 0 : this.getWorkspaceId().hashCode());
        hashCode = 31 * hashCode + (this.getEntityId() == null ? 0 : this.getEntityId().hashCode());
        hashCode = 31 * hashCode + (this.getEntityName() == null ? 0 : this.getEntityName().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getComponentUpdates() == null ? 0 : this.getComponentUpdates().hashCode());
        hashCode = 31 * hashCode + (this.getCompositeComponentUpdates() == null ? 0 : this.getCompositeComponentUpdates().hashCode());
        hashCode = 31 * hashCode + (this.getParentEntityUpdate() == null ? 0 : this.getParentEntityUpdate().hashCode());
        return hashCode;
    }

    public UpdateEntityRequest clone() {
        return (UpdateEntityRequest)super.clone();
    }
}

