/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iottwinmaker.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.iottwinmaker.model.EntityPropertyReference;
import com.amazonaws.services.iottwinmaker.model.PropertyValue;
import com.amazonaws.services.iottwinmaker.model.transform.PropertyValueHistoryMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PropertyValueHistory
implements Serializable,
Cloneable,
StructuredPojo {
    private EntityPropertyReference entityPropertyReference;
    private List<PropertyValue> values;

    public void setEntityPropertyReference(EntityPropertyReference entityPropertyReference) {
        this.entityPropertyReference = entityPropertyReference;
    }

    public EntityPropertyReference getEntityPropertyReference() {
        return this.entityPropertyReference;
    }

    public PropertyValueHistory withEntityPropertyReference(EntityPropertyReference entityPropertyReference) {
        this.setEntityPropertyReference(entityPropertyReference);
        return this;
    }

    public List<PropertyValue> getValues() {
        return this.values;
    }

    public void setValues(Collection<PropertyValue> values) {
        if (values == null) {
            this.values = null;
            return;
        }
        this.values = new ArrayList<PropertyValue>(values);
    }

    public PropertyValueHistory withValues(PropertyValue ... values) {
        if (this.values == null) {
            this.setValues(new ArrayList<PropertyValue>(values.length));
        }
        for (PropertyValue ele : values) {
            this.values.add(ele);
        }
        return this;
    }

    public PropertyValueHistory withValues(Collection<PropertyValue> values) {
        this.setValues(values);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEntityPropertyReference() != null) {
            sb.append("EntityPropertyReference: ").append(this.getEntityPropertyReference()).append(",");
        }
        if (this.getValues() != null) {
            sb.append("Values: ").append(this.getValues());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PropertyValueHistory)) {
            return false;
        }
        PropertyValueHistory other = (PropertyValueHistory)obj;
        if (other.getEntityPropertyReference() == null ^ this.getEntityPropertyReference() == null) {
            return false;
        }
        if (other.getEntityPropertyReference() != null && !other.getEntityPropertyReference().equals(this.getEntityPropertyReference())) {
            return false;
        }
        if (other.getValues() == null ^ this.getValues() == null) {
            return false;
        }
        return other.getValues() == null || other.getValues().equals(this.getValues());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEntityPropertyReference() == null ? 0 : this.getEntityPropertyReference().hashCode());
        hashCode = 31 * hashCode + (this.getValues() == null ? 0 : this.getValues().hashCode());
        return hashCode;
    }

    public PropertyValueHistory clone() {
        try {
            return (PropertyValueHistory)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PropertyValueHistoryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

