/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.iottwinmaker;

import javax.annotation.Generated;

import com.amazonaws.services.iottwinmaker.model.*;

/**
 * Abstract implementation of {@code AWSIoTTwinMakerAsync}. Convenient method forms pass through to the corresponding
 * overload that takes a request object and an {@code AsyncHandler}, which throws an
 * {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAWSIoTTwinMakerAsync extends AbstractAWSIoTTwinMaker implements AWSIoTTwinMakerAsync {

    protected AbstractAWSIoTTwinMakerAsync() {
    }

    @Override
    public java.util.concurrent.Future<BatchPutPropertyValuesResult> batchPutPropertyValuesAsync(BatchPutPropertyValuesRequest request) {

        return batchPutPropertyValuesAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<BatchPutPropertyValuesResult> batchPutPropertyValuesAsync(BatchPutPropertyValuesRequest request,
            com.amazonaws.handlers.AsyncHandler<BatchPutPropertyValuesRequest, BatchPutPropertyValuesResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateComponentTypeResult> createComponentTypeAsync(CreateComponentTypeRequest request) {

        return createComponentTypeAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateComponentTypeResult> createComponentTypeAsync(CreateComponentTypeRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateComponentTypeRequest, CreateComponentTypeResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateEntityResult> createEntityAsync(CreateEntityRequest request) {

        return createEntityAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateEntityResult> createEntityAsync(CreateEntityRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateEntityRequest, CreateEntityResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateSceneResult> createSceneAsync(CreateSceneRequest request) {

        return createSceneAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateSceneResult> createSceneAsync(CreateSceneRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateSceneRequest, CreateSceneResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateSyncJobResult> createSyncJobAsync(CreateSyncJobRequest request) {

        return createSyncJobAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateSyncJobResult> createSyncJobAsync(CreateSyncJobRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateSyncJobRequest, CreateSyncJobResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateWorkspaceResult> createWorkspaceAsync(CreateWorkspaceRequest request) {

        return createWorkspaceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateWorkspaceResult> createWorkspaceAsync(CreateWorkspaceRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateWorkspaceRequest, CreateWorkspaceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteComponentTypeResult> deleteComponentTypeAsync(DeleteComponentTypeRequest request) {

        return deleteComponentTypeAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteComponentTypeResult> deleteComponentTypeAsync(DeleteComponentTypeRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteComponentTypeRequest, DeleteComponentTypeResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteEntityResult> deleteEntityAsync(DeleteEntityRequest request) {

        return deleteEntityAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteEntityResult> deleteEntityAsync(DeleteEntityRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteEntityRequest, DeleteEntityResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteSceneResult> deleteSceneAsync(DeleteSceneRequest request) {

        return deleteSceneAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteSceneResult> deleteSceneAsync(DeleteSceneRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteSceneRequest, DeleteSceneResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteSyncJobResult> deleteSyncJobAsync(DeleteSyncJobRequest request) {

        return deleteSyncJobAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteSyncJobResult> deleteSyncJobAsync(DeleteSyncJobRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteSyncJobRequest, DeleteSyncJobResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteWorkspaceResult> deleteWorkspaceAsync(DeleteWorkspaceRequest request) {

        return deleteWorkspaceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteWorkspaceResult> deleteWorkspaceAsync(DeleteWorkspaceRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteWorkspaceRequest, DeleteWorkspaceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ExecuteQueryResult> executeQueryAsync(ExecuteQueryRequest request) {

        return executeQueryAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ExecuteQueryResult> executeQueryAsync(ExecuteQueryRequest request,
            com.amazonaws.handlers.AsyncHandler<ExecuteQueryRequest, ExecuteQueryResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetComponentTypeResult> getComponentTypeAsync(GetComponentTypeRequest request) {

        return getComponentTypeAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetComponentTypeResult> getComponentTypeAsync(GetComponentTypeRequest request,
            com.amazonaws.handlers.AsyncHandler<GetComponentTypeRequest, GetComponentTypeResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetEntityResult> getEntityAsync(GetEntityRequest request) {

        return getEntityAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetEntityResult> getEntityAsync(GetEntityRequest request,
            com.amazonaws.handlers.AsyncHandler<GetEntityRequest, GetEntityResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetPricingPlanResult> getPricingPlanAsync(GetPricingPlanRequest request) {

        return getPricingPlanAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetPricingPlanResult> getPricingPlanAsync(GetPricingPlanRequest request,
            com.amazonaws.handlers.AsyncHandler<GetPricingPlanRequest, GetPricingPlanResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetPropertyValueResult> getPropertyValueAsync(GetPropertyValueRequest request) {

        return getPropertyValueAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetPropertyValueResult> getPropertyValueAsync(GetPropertyValueRequest request,
            com.amazonaws.handlers.AsyncHandler<GetPropertyValueRequest, GetPropertyValueResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetPropertyValueHistoryResult> getPropertyValueHistoryAsync(GetPropertyValueHistoryRequest request) {

        return getPropertyValueHistoryAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetPropertyValueHistoryResult> getPropertyValueHistoryAsync(GetPropertyValueHistoryRequest request,
            com.amazonaws.handlers.AsyncHandler<GetPropertyValueHistoryRequest, GetPropertyValueHistoryResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetSceneResult> getSceneAsync(GetSceneRequest request) {

        return getSceneAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetSceneResult> getSceneAsync(GetSceneRequest request,
            com.amazonaws.handlers.AsyncHandler<GetSceneRequest, GetSceneResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetSyncJobResult> getSyncJobAsync(GetSyncJobRequest request) {

        return getSyncJobAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetSyncJobResult> getSyncJobAsync(GetSyncJobRequest request,
            com.amazonaws.handlers.AsyncHandler<GetSyncJobRequest, GetSyncJobResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetWorkspaceResult> getWorkspaceAsync(GetWorkspaceRequest request) {

        return getWorkspaceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetWorkspaceResult> getWorkspaceAsync(GetWorkspaceRequest request,
            com.amazonaws.handlers.AsyncHandler<GetWorkspaceRequest, GetWorkspaceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListComponentTypesResult> listComponentTypesAsync(ListComponentTypesRequest request) {

        return listComponentTypesAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListComponentTypesResult> listComponentTypesAsync(ListComponentTypesRequest request,
            com.amazonaws.handlers.AsyncHandler<ListComponentTypesRequest, ListComponentTypesResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListEntitiesResult> listEntitiesAsync(ListEntitiesRequest request) {

        return listEntitiesAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListEntitiesResult> listEntitiesAsync(ListEntitiesRequest request,
            com.amazonaws.handlers.AsyncHandler<ListEntitiesRequest, ListEntitiesResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListScenesResult> listScenesAsync(ListScenesRequest request) {

        return listScenesAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListScenesResult> listScenesAsync(ListScenesRequest request,
            com.amazonaws.handlers.AsyncHandler<ListScenesRequest, ListScenesResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListSyncJobsResult> listSyncJobsAsync(ListSyncJobsRequest request) {

        return listSyncJobsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListSyncJobsResult> listSyncJobsAsync(ListSyncJobsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListSyncJobsRequest, ListSyncJobsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListSyncResourcesResult> listSyncResourcesAsync(ListSyncResourcesRequest request) {

        return listSyncResourcesAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListSyncResourcesResult> listSyncResourcesAsync(ListSyncResourcesRequest request,
            com.amazonaws.handlers.AsyncHandler<ListSyncResourcesRequest, ListSyncResourcesResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {

        return listTagsForResourceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request,
            com.amazonaws.handlers.AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListWorkspacesResult> listWorkspacesAsync(ListWorkspacesRequest request) {

        return listWorkspacesAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListWorkspacesResult> listWorkspacesAsync(ListWorkspacesRequest request,
            com.amazonaws.handlers.AsyncHandler<ListWorkspacesRequest, ListWorkspacesResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {

        return tagResourceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<TagResourceResult> tagResourceAsync(TagResourceRequest request,
            com.amazonaws.handlers.AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {

        return untagResourceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request,
            com.amazonaws.handlers.AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateComponentTypeResult> updateComponentTypeAsync(UpdateComponentTypeRequest request) {

        return updateComponentTypeAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateComponentTypeResult> updateComponentTypeAsync(UpdateComponentTypeRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateComponentTypeRequest, UpdateComponentTypeResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateEntityResult> updateEntityAsync(UpdateEntityRequest request) {

        return updateEntityAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateEntityResult> updateEntityAsync(UpdateEntityRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateEntityRequest, UpdateEntityResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdatePricingPlanResult> updatePricingPlanAsync(UpdatePricingPlanRequest request) {

        return updatePricingPlanAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdatePricingPlanResult> updatePricingPlanAsync(UpdatePricingPlanRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdatePricingPlanRequest, UpdatePricingPlanResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateSceneResult> updateSceneAsync(UpdateSceneRequest request) {

        return updateSceneAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateSceneResult> updateSceneAsync(UpdateSceneRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateSceneRequest, UpdateSceneResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateWorkspaceResult> updateWorkspaceAsync(UpdateWorkspaceRequest request) {

        return updateWorkspaceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateWorkspaceResult> updateWorkspaceAsync(UpdateWorkspaceRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateWorkspaceRequest, UpdateWorkspaceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

}
