/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iottwinmaker.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.iottwinmaker.model.DataValue;
import com.amazonaws.services.iottwinmaker.model.PropertyLatestValue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GetPropertyValueResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private Map<String, PropertyLatestValue> propertyValues;
    private String nextToken;
    private List<List<Map<String, DataValue>>> tabularPropertyValues;

    public Map<String, PropertyLatestValue> getPropertyValues() {
        return this.propertyValues;
    }

    public void setPropertyValues(Map<String, PropertyLatestValue> propertyValues) {
        this.propertyValues = propertyValues;
    }

    public GetPropertyValueResult withPropertyValues(Map<String, PropertyLatestValue> propertyValues) {
        this.setPropertyValues(propertyValues);
        return this;
    }

    public GetPropertyValueResult addPropertyValuesEntry(String key, PropertyLatestValue value) {
        if (null == this.propertyValues) {
            this.propertyValues = new HashMap<String, PropertyLatestValue>();
        }
        if (this.propertyValues.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.propertyValues.put(key, value);
        return this;
    }

    public GetPropertyValueResult clearPropertyValuesEntries() {
        this.propertyValues = null;
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public GetPropertyValueResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public List<List<Map<String, DataValue>>> getTabularPropertyValues() {
        return this.tabularPropertyValues;
    }

    public void setTabularPropertyValues(Collection<List<Map<String, DataValue>>> tabularPropertyValues) {
        if (tabularPropertyValues == null) {
            this.tabularPropertyValues = null;
            return;
        }
        this.tabularPropertyValues = new ArrayList<List<Map<String, DataValue>>>(tabularPropertyValues);
    }

    public GetPropertyValueResult withTabularPropertyValues(List<Map<String, DataValue>> ... tabularPropertyValues) {
        if (this.tabularPropertyValues == null) {
            this.setTabularPropertyValues(new ArrayList<List<Map<String, DataValue>>>(tabularPropertyValues.length));
        }
        for (List<Map<String, DataValue>> ele : tabularPropertyValues) {
            this.tabularPropertyValues.add(ele);
        }
        return this;
    }

    public GetPropertyValueResult withTabularPropertyValues(Collection<List<Map<String, DataValue>>> tabularPropertyValues) {
        this.setTabularPropertyValues(tabularPropertyValues);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPropertyValues() != null) {
            sb.append("PropertyValues: ").append(this.getPropertyValues()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getTabularPropertyValues() != null) {
            sb.append("TabularPropertyValues: ").append(this.getTabularPropertyValues());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPropertyValueResult)) {
            return false;
        }
        GetPropertyValueResult other = (GetPropertyValueResult)obj;
        if (other.getPropertyValues() == null ^ this.getPropertyValues() == null) {
            return false;
        }
        if (other.getPropertyValues() != null && !other.getPropertyValues().equals(this.getPropertyValues())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getTabularPropertyValues() == null ^ this.getTabularPropertyValues() == null) {
            return false;
        }
        return other.getTabularPropertyValues() == null || other.getTabularPropertyValues().equals(this.getTabularPropertyValues());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPropertyValues() == null ? 0 : this.getPropertyValues().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getTabularPropertyValues() == null ? 0 : this.getTabularPropertyValues().hashCode());
        return hashCode;
    }

    public GetPropertyValueResult clone() {
        try {
            return (GetPropertyValueResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

