/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iottwinmaker.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.iottwinmaker.model.ComponentRequest;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class CreateEntityRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private Map<String, ComponentRequest> components;
    private String description;
    private String entityId;
    private String entityName;
    private String parentEntityId;
    private Map<String, String> tags;
    private String workspaceId;

    public Map<String, ComponentRequest> getComponents() {
        return this.components;
    }

    public void setComponents(Map<String, ComponentRequest> components) {
        this.components = components;
    }

    public CreateEntityRequest withComponents(Map<String, ComponentRequest> components) {
        this.setComponents(components);
        return this;
    }

    public CreateEntityRequest addComponentsEntry(String key, ComponentRequest value) {
        if (null == this.components) {
            this.components = new HashMap<String, ComponentRequest>();
        }
        if (this.components.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.components.put(key, value);
        return this;
    }

    public CreateEntityRequest clearComponentsEntries() {
        this.components = null;
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public CreateEntityRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public CreateEntityRequest withEntityId(String entityId) {
        this.setEntityId(entityId);
        return this;
    }

    public void setEntityName(String entityName) {
        this.entityName = entityName;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public CreateEntityRequest withEntityName(String entityName) {
        this.setEntityName(entityName);
        return this;
    }

    public void setParentEntityId(String parentEntityId) {
        this.parentEntityId = parentEntityId;
    }

    public String getParentEntityId() {
        return this.parentEntityId;
    }

    public CreateEntityRequest withParentEntityId(String parentEntityId) {
        this.setParentEntityId(parentEntityId);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public CreateEntityRequest withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public CreateEntityRequest addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public CreateEntityRequest clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public void setWorkspaceId(String workspaceId) {
        this.workspaceId = workspaceId;
    }

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public CreateEntityRequest withWorkspaceId(String workspaceId) {
        this.setWorkspaceId(workspaceId);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getComponents() != null) {
            sb.append("Components: ").append(this.getComponents()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getEntityId() != null) {
            sb.append("EntityId: ").append(this.getEntityId()).append(",");
        }
        if (this.getEntityName() != null) {
            sb.append("EntityName: ").append(this.getEntityName()).append(",");
        }
        if (this.getParentEntityId() != null) {
            sb.append("ParentEntityId: ").append(this.getParentEntityId()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getWorkspaceId() != null) {
            sb.append("WorkspaceId: ").append(this.getWorkspaceId());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateEntityRequest)) {
            return false;
        }
        CreateEntityRequest other = (CreateEntityRequest)obj;
        if (other.getComponents() == null ^ this.getComponents() == null) {
            return false;
        }
        if (other.getComponents() != null && !other.getComponents().equals(this.getComponents())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getEntityId() == null ^ this.getEntityId() == null) {
            return false;
        }
        if (other.getEntityId() != null && !other.getEntityId().equals(this.getEntityId())) {
            return false;
        }
        if (other.getEntityName() == null ^ this.getEntityName() == null) {
            return false;
        }
        if (other.getEntityName() != null && !other.getEntityName().equals(this.getEntityName())) {
            return false;
        }
        if (other.getParentEntityId() == null ^ this.getParentEntityId() == null) {
            return false;
        }
        if (other.getParentEntityId() != null && !other.getParentEntityId().equals(this.getParentEntityId())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getWorkspaceId() == null ^ this.getWorkspaceId() == null) {
            return false;
        }
        return other.getWorkspaceId() == null || other.getWorkspaceId().equals(this.getWorkspaceId());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getComponents() == null ? 0 : this.getComponents().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getEntityId() == null ? 0 : this.getEntityId().hashCode());
        hashCode = 31 * hashCode + (this.getEntityName() == null ? 0 : this.getEntityName().hashCode());
        hashCode = 31 * hashCode + (this.getParentEntityId() == null ? 0 : this.getParentEntityId().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getWorkspaceId() == null ? 0 : this.getWorkspaceId().hashCode());
        return hashCode;
    }

    public CreateEntityRequest clone() {
        return (CreateEntityRequest)super.clone();
    }
}

