/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iottwinmaker.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.iottwinmaker.model.PropertyValueEntry;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class BatchPutPropertyValuesRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private List<PropertyValueEntry> entries;
    private String workspaceId;

    public List<PropertyValueEntry> getEntries() {
        return this.entries;
    }

    public void setEntries(Collection<PropertyValueEntry> entries) {
        if (entries == null) {
            this.entries = null;
            return;
        }
        this.entries = new ArrayList<PropertyValueEntry>(entries);
    }

    public BatchPutPropertyValuesRequest withEntries(PropertyValueEntry ... entries) {
        if (this.entries == null) {
            this.setEntries(new ArrayList<PropertyValueEntry>(entries.length));
        }
        for (PropertyValueEntry ele : entries) {
            this.entries.add(ele);
        }
        return this;
    }

    public BatchPutPropertyValuesRequest withEntries(Collection<PropertyValueEntry> entries) {
        this.setEntries(entries);
        return this;
    }

    public void setWorkspaceId(String workspaceId) {
        this.workspaceId = workspaceId;
    }

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public BatchPutPropertyValuesRequest withWorkspaceId(String workspaceId) {
        this.setWorkspaceId(workspaceId);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEntries() != null) {
            sb.append("Entries: ").append(this.getEntries()).append(",");
        }
        if (this.getWorkspaceId() != null) {
            sb.append("WorkspaceId: ").append(this.getWorkspaceId());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchPutPropertyValuesRequest)) {
            return false;
        }
        BatchPutPropertyValuesRequest other = (BatchPutPropertyValuesRequest)obj;
        if (other.getEntries() == null ^ this.getEntries() == null) {
            return false;
        }
        if (other.getEntries() != null && !other.getEntries().equals(this.getEntries())) {
            return false;
        }
        if (other.getWorkspaceId() == null ^ this.getWorkspaceId() == null) {
            return false;
        }
        return other.getWorkspaceId() == null || other.getWorkspaceId().equals(this.getWorkspaceId());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEntries() == null ? 0 : this.getEntries().hashCode());
        hashCode = 31 * hashCode + (this.getWorkspaceId() == null ? 0 : this.getWorkspaceId().hashCode());
        return hashCode;
    }

    public BatchPutPropertyValuesRequest clone() {
        return (BatchPutPropertyValuesRequest)super.clone();
    }
}

