/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iotroborunner;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.iotroborunner.AWSIoTRoboRunner;
import com.amazonaws.services.iotroborunner.AWSIoTRoboRunnerClientBuilder;
import com.amazonaws.services.iotroborunner.model.AWSIoTRoboRunnerException;
import com.amazonaws.services.iotroborunner.model.CreateDestinationRequest;
import com.amazonaws.services.iotroborunner.model.CreateDestinationResult;
import com.amazonaws.services.iotroborunner.model.CreateSiteRequest;
import com.amazonaws.services.iotroborunner.model.CreateSiteResult;
import com.amazonaws.services.iotroborunner.model.CreateWorkerFleetRequest;
import com.amazonaws.services.iotroborunner.model.CreateWorkerFleetResult;
import com.amazonaws.services.iotroborunner.model.CreateWorkerRequest;
import com.amazonaws.services.iotroborunner.model.CreateWorkerResult;
import com.amazonaws.services.iotroborunner.model.DeleteDestinationRequest;
import com.amazonaws.services.iotroborunner.model.DeleteDestinationResult;
import com.amazonaws.services.iotroborunner.model.DeleteSiteRequest;
import com.amazonaws.services.iotroborunner.model.DeleteSiteResult;
import com.amazonaws.services.iotroborunner.model.DeleteWorkerFleetRequest;
import com.amazonaws.services.iotroborunner.model.DeleteWorkerFleetResult;
import com.amazonaws.services.iotroborunner.model.DeleteWorkerRequest;
import com.amazonaws.services.iotroborunner.model.DeleteWorkerResult;
import com.amazonaws.services.iotroborunner.model.GetDestinationRequest;
import com.amazonaws.services.iotroborunner.model.GetDestinationResult;
import com.amazonaws.services.iotroborunner.model.GetSiteRequest;
import com.amazonaws.services.iotroborunner.model.GetSiteResult;
import com.amazonaws.services.iotroborunner.model.GetWorkerFleetRequest;
import com.amazonaws.services.iotroborunner.model.GetWorkerFleetResult;
import com.amazonaws.services.iotroborunner.model.GetWorkerRequest;
import com.amazonaws.services.iotroborunner.model.GetWorkerResult;
import com.amazonaws.services.iotroborunner.model.ListDestinationsRequest;
import com.amazonaws.services.iotroborunner.model.ListDestinationsResult;
import com.amazonaws.services.iotroborunner.model.ListSitesRequest;
import com.amazonaws.services.iotroborunner.model.ListSitesResult;
import com.amazonaws.services.iotroborunner.model.ListWorkerFleetsRequest;
import com.amazonaws.services.iotroborunner.model.ListWorkerFleetsResult;
import com.amazonaws.services.iotroborunner.model.ListWorkersRequest;
import com.amazonaws.services.iotroborunner.model.ListWorkersResult;
import com.amazonaws.services.iotroborunner.model.UpdateDestinationRequest;
import com.amazonaws.services.iotroborunner.model.UpdateDestinationResult;
import com.amazonaws.services.iotroborunner.model.UpdateSiteRequest;
import com.amazonaws.services.iotroborunner.model.UpdateSiteResult;
import com.amazonaws.services.iotroborunner.model.UpdateWorkerFleetRequest;
import com.amazonaws.services.iotroborunner.model.UpdateWorkerFleetResult;
import com.amazonaws.services.iotroborunner.model.UpdateWorkerRequest;
import com.amazonaws.services.iotroborunner.model.UpdateWorkerResult;
import com.amazonaws.services.iotroborunner.model.transform.AccessDeniedExceptionUnmarshaller;
import com.amazonaws.services.iotroborunner.model.transform.ConflictExceptionUnmarshaller;
import com.amazonaws.services.iotroborunner.model.transform.CreateDestinationRequestProtocolMarshaller;
import com.amazonaws.services.iotroborunner.model.transform.CreateDestinationResultJsonUnmarshaller;
import com.amazonaws.services.iotroborunner.model.transform.CreateSiteRequestProtocolMarshaller;
import com.amazonaws.services.iotroborunner.model.transform.CreateSiteResultJsonUnmarshaller;
import com.amazonaws.services.iotroborunner.model.transform.CreateWorkerFleetRequestProtocolMarshaller;
import com.amazonaws.services.iotroborunner.model.transform.CreateWorkerFleetResultJsonUnmarshaller;
import com.amazonaws.services.iotroborunner.model.transform.CreateWorkerRequestProtocolMarshaller;
import com.amazonaws.services.iotroborunner.model.transform.CreateWorkerResultJsonUnmarshaller;
import com.amazonaws.services.iotroborunner.model.transform.DeleteDestinationRequestProtocolMarshaller;
import com.amazonaws.services.iotroborunner.model.transform.DeleteDestinationResultJsonUnmarshaller;
import com.amazonaws.services.iotroborunner.model.transform.DeleteSiteRequestProtocolMarshaller;
import com.amazonaws.services.iotroborunner.model.transform.DeleteSiteResultJsonUnmarshaller;
import com.amazonaws.services.iotroborunner.model.transform.DeleteWorkerFleetRequestProtocolMarshaller;
import com.amazonaws.services.iotroborunner.model.transform.DeleteWorkerFleetResultJsonUnmarshaller;
import com.amazonaws.services.iotroborunner.model.transform.DeleteWorkerRequestProtocolMarshaller;
import com.amazonaws.services.iotroborunner.model.transform.DeleteWorkerResultJsonUnmarshaller;
import com.amazonaws.services.iotroborunner.model.transform.GetDestinationRequestProtocolMarshaller;
import com.amazonaws.services.iotroborunner.model.transform.GetDestinationResultJsonUnmarshaller;
import com.amazonaws.services.iotroborunner.model.transform.GetSiteRequestProtocolMarshaller;
import com.amazonaws.services.iotroborunner.model.transform.GetSiteResultJsonUnmarshaller;
import com.amazonaws.services.iotroborunner.model.transform.GetWorkerFleetRequestProtocolMarshaller;
import com.amazonaws.services.iotroborunner.model.transform.GetWorkerFleetResultJsonUnmarshaller;
import com.amazonaws.services.iotroborunner.model.transform.GetWorkerRequestProtocolMarshaller;
import com.amazonaws.services.iotroborunner.model.transform.GetWorkerResultJsonUnmarshaller;
import com.amazonaws.services.iotroborunner.model.transform.InternalServerExceptionUnmarshaller;
import com.amazonaws.services.iotroborunner.model.transform.ListDestinationsRequestProtocolMarshaller;
import com.amazonaws.services.iotroborunner.model.transform.ListDestinationsResultJsonUnmarshaller;
import com.amazonaws.services.iotroborunner.model.transform.ListSitesRequestProtocolMarshaller;
import com.amazonaws.services.iotroborunner.model.transform.ListSitesResultJsonUnmarshaller;
import com.amazonaws.services.iotroborunner.model.transform.ListWorkerFleetsRequestProtocolMarshaller;
import com.amazonaws.services.iotroborunner.model.transform.ListWorkerFleetsResultJsonUnmarshaller;
import com.amazonaws.services.iotroborunner.model.transform.ListWorkersRequestProtocolMarshaller;
import com.amazonaws.services.iotroborunner.model.transform.ListWorkersResultJsonUnmarshaller;
import com.amazonaws.services.iotroborunner.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.iotroborunner.model.transform.ServiceQuotaExceededExceptionUnmarshaller;
import com.amazonaws.services.iotroborunner.model.transform.ThrottlingExceptionUnmarshaller;
import com.amazonaws.services.iotroborunner.model.transform.UpdateDestinationRequestProtocolMarshaller;
import com.amazonaws.services.iotroborunner.model.transform.UpdateDestinationResultJsonUnmarshaller;
import com.amazonaws.services.iotroborunner.model.transform.UpdateSiteRequestProtocolMarshaller;
import com.amazonaws.services.iotroborunner.model.transform.UpdateSiteResultJsonUnmarshaller;
import com.amazonaws.services.iotroborunner.model.transform.UpdateWorkerFleetRequestProtocolMarshaller;
import com.amazonaws.services.iotroborunner.model.transform.UpdateWorkerFleetResultJsonUnmarshaller;
import com.amazonaws.services.iotroborunner.model.transform.UpdateWorkerRequestProtocolMarshaller;
import com.amazonaws.services.iotroborunner.model.transform.UpdateWorkerResultJsonUnmarshaller;
import com.amazonaws.services.iotroborunner.model.transform.ValidationExceptionUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AWSIoTRoboRunnerClient
extends AmazonWebServiceClient
implements AWSIoTRoboRunner {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSIoTRoboRunner.class);
    private static final String DEFAULT_SIGNING_NAME = "iotroborunner";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("application/json").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AccessDeniedException").withExceptionUnmarshaller((JsonErrorUnmarshaller)AccessDeniedExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConflictException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ConflictExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ThrottlingException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ThrottlingExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ValidationException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ValidationExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceQuotaExceededException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ServiceQuotaExceededExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InternalServerExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AWSIoTRoboRunnerException.class));

    public static AWSIoTRoboRunnerClientBuilder builder() {
        return AWSIoTRoboRunnerClientBuilder.standard();
    }

    AWSIoTRoboRunnerClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AWSIoTRoboRunnerClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("iotroborunner.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/iotroborunner/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/iotroborunner/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public CreateDestinationResult createDestination(CreateDestinationRequest request) {
        request = (CreateDestinationRequest)this.beforeClientExecution(request);
        return this.executeCreateDestination(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateDestinationResult executeCreateDestination(CreateDestinationRequest createDestinationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createDestinationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateDestinationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateDestinationRequestProtocolMarshaller(protocolFactory).marshall((CreateDestinationRequest)super.beforeMarshalling((AmazonWebServiceRequest)createDestinationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IoT RoboRunner");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateDestination");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateDestinationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateDestinationResult createDestinationResult = (CreateDestinationResult)response.getAwsResponse();
            return createDestinationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateSiteResult createSite(CreateSiteRequest request) {
        request = (CreateSiteRequest)this.beforeClientExecution(request);
        return this.executeCreateSite(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateSiteResult executeCreateSite(CreateSiteRequest createSiteRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createSiteRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateSiteRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateSiteRequestProtocolMarshaller(protocolFactory).marshall((CreateSiteRequest)super.beforeMarshalling((AmazonWebServiceRequest)createSiteRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IoT RoboRunner");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateSite");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateSiteResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateSiteResult createSiteResult = (CreateSiteResult)response.getAwsResponse();
            return createSiteResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateWorkerResult createWorker(CreateWorkerRequest request) {
        request = (CreateWorkerRequest)this.beforeClientExecution(request);
        return this.executeCreateWorker(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateWorkerResult executeCreateWorker(CreateWorkerRequest createWorkerRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createWorkerRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateWorkerRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateWorkerRequestProtocolMarshaller(protocolFactory).marshall((CreateWorkerRequest)super.beforeMarshalling((AmazonWebServiceRequest)createWorkerRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IoT RoboRunner");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateWorker");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateWorkerResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateWorkerResult createWorkerResult = (CreateWorkerResult)response.getAwsResponse();
            return createWorkerResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateWorkerFleetResult createWorkerFleet(CreateWorkerFleetRequest request) {
        request = (CreateWorkerFleetRequest)this.beforeClientExecution(request);
        return this.executeCreateWorkerFleet(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateWorkerFleetResult executeCreateWorkerFleet(CreateWorkerFleetRequest createWorkerFleetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createWorkerFleetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateWorkerFleetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateWorkerFleetRequestProtocolMarshaller(protocolFactory).marshall((CreateWorkerFleetRequest)super.beforeMarshalling((AmazonWebServiceRequest)createWorkerFleetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IoT RoboRunner");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateWorkerFleet");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateWorkerFleetResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateWorkerFleetResult createWorkerFleetResult = (CreateWorkerFleetResult)response.getAwsResponse();
            return createWorkerFleetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteDestinationResult deleteDestination(DeleteDestinationRequest request) {
        request = (DeleteDestinationRequest)this.beforeClientExecution(request);
        return this.executeDeleteDestination(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteDestinationResult executeDeleteDestination(DeleteDestinationRequest deleteDestinationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteDestinationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteDestinationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteDestinationRequestProtocolMarshaller(protocolFactory).marshall((DeleteDestinationRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteDestinationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IoT RoboRunner");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteDestination");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteDestinationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteDestinationResult deleteDestinationResult = (DeleteDestinationResult)response.getAwsResponse();
            return deleteDestinationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteSiteResult deleteSite(DeleteSiteRequest request) {
        request = (DeleteSiteRequest)this.beforeClientExecution(request);
        return this.executeDeleteSite(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteSiteResult executeDeleteSite(DeleteSiteRequest deleteSiteRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteSiteRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteSiteRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteSiteRequestProtocolMarshaller(protocolFactory).marshall((DeleteSiteRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteSiteRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IoT RoboRunner");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteSite");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteSiteResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteSiteResult deleteSiteResult = (DeleteSiteResult)response.getAwsResponse();
            return deleteSiteResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteWorkerResult deleteWorker(DeleteWorkerRequest request) {
        request = (DeleteWorkerRequest)this.beforeClientExecution(request);
        return this.executeDeleteWorker(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteWorkerResult executeDeleteWorker(DeleteWorkerRequest deleteWorkerRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteWorkerRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteWorkerRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteWorkerRequestProtocolMarshaller(protocolFactory).marshall((DeleteWorkerRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteWorkerRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IoT RoboRunner");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteWorker");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteWorkerResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteWorkerResult deleteWorkerResult = (DeleteWorkerResult)response.getAwsResponse();
            return deleteWorkerResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteWorkerFleetResult deleteWorkerFleet(DeleteWorkerFleetRequest request) {
        request = (DeleteWorkerFleetRequest)this.beforeClientExecution(request);
        return this.executeDeleteWorkerFleet(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteWorkerFleetResult executeDeleteWorkerFleet(DeleteWorkerFleetRequest deleteWorkerFleetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteWorkerFleetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteWorkerFleetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteWorkerFleetRequestProtocolMarshaller(protocolFactory).marshall((DeleteWorkerFleetRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteWorkerFleetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IoT RoboRunner");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteWorkerFleet");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteWorkerFleetResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteWorkerFleetResult deleteWorkerFleetResult = (DeleteWorkerFleetResult)response.getAwsResponse();
            return deleteWorkerFleetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetDestinationResult getDestination(GetDestinationRequest request) {
        request = (GetDestinationRequest)this.beforeClientExecution(request);
        return this.executeGetDestination(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetDestinationResult executeGetDestination(GetDestinationRequest getDestinationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getDestinationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetDestinationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetDestinationRequestProtocolMarshaller(protocolFactory).marshall((GetDestinationRequest)super.beforeMarshalling((AmazonWebServiceRequest)getDestinationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IoT RoboRunner");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetDestination");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetDestinationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetDestinationResult getDestinationResult = (GetDestinationResult)response.getAwsResponse();
            return getDestinationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetSiteResult getSite(GetSiteRequest request) {
        request = (GetSiteRequest)this.beforeClientExecution(request);
        return this.executeGetSite(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetSiteResult executeGetSite(GetSiteRequest getSiteRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getSiteRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetSiteRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetSiteRequestProtocolMarshaller(protocolFactory).marshall((GetSiteRequest)super.beforeMarshalling((AmazonWebServiceRequest)getSiteRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IoT RoboRunner");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetSite");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetSiteResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetSiteResult getSiteResult = (GetSiteResult)response.getAwsResponse();
            return getSiteResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetWorkerResult getWorker(GetWorkerRequest request) {
        request = (GetWorkerRequest)this.beforeClientExecution(request);
        return this.executeGetWorker(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetWorkerResult executeGetWorker(GetWorkerRequest getWorkerRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getWorkerRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetWorkerRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetWorkerRequestProtocolMarshaller(protocolFactory).marshall((GetWorkerRequest)super.beforeMarshalling((AmazonWebServiceRequest)getWorkerRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IoT RoboRunner");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetWorker");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetWorkerResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetWorkerResult getWorkerResult = (GetWorkerResult)response.getAwsResponse();
            return getWorkerResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetWorkerFleetResult getWorkerFleet(GetWorkerFleetRequest request) {
        request = (GetWorkerFleetRequest)this.beforeClientExecution(request);
        return this.executeGetWorkerFleet(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetWorkerFleetResult executeGetWorkerFleet(GetWorkerFleetRequest getWorkerFleetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getWorkerFleetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetWorkerFleetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetWorkerFleetRequestProtocolMarshaller(protocolFactory).marshall((GetWorkerFleetRequest)super.beforeMarshalling((AmazonWebServiceRequest)getWorkerFleetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IoT RoboRunner");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetWorkerFleet");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetWorkerFleetResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetWorkerFleetResult getWorkerFleetResult = (GetWorkerFleetResult)response.getAwsResponse();
            return getWorkerFleetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListDestinationsResult listDestinations(ListDestinationsRequest request) {
        request = (ListDestinationsRequest)this.beforeClientExecution(request);
        return this.executeListDestinations(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListDestinationsResult executeListDestinations(ListDestinationsRequest listDestinationsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listDestinationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListDestinationsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListDestinationsRequestProtocolMarshaller(protocolFactory).marshall((ListDestinationsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listDestinationsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IoT RoboRunner");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListDestinations");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListDestinationsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListDestinationsResult listDestinationsResult = (ListDestinationsResult)response.getAwsResponse();
            return listDestinationsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListSitesResult listSites(ListSitesRequest request) {
        request = (ListSitesRequest)this.beforeClientExecution(request);
        return this.executeListSites(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListSitesResult executeListSites(ListSitesRequest listSitesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listSitesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListSitesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListSitesRequestProtocolMarshaller(protocolFactory).marshall((ListSitesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listSitesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IoT RoboRunner");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListSites");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListSitesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListSitesResult listSitesResult = (ListSitesResult)response.getAwsResponse();
            return listSitesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListWorkerFleetsResult listWorkerFleets(ListWorkerFleetsRequest request) {
        request = (ListWorkerFleetsRequest)this.beforeClientExecution(request);
        return this.executeListWorkerFleets(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListWorkerFleetsResult executeListWorkerFleets(ListWorkerFleetsRequest listWorkerFleetsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listWorkerFleetsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListWorkerFleetsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListWorkerFleetsRequestProtocolMarshaller(protocolFactory).marshall((ListWorkerFleetsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listWorkerFleetsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IoT RoboRunner");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListWorkerFleets");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListWorkerFleetsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListWorkerFleetsResult listWorkerFleetsResult = (ListWorkerFleetsResult)response.getAwsResponse();
            return listWorkerFleetsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListWorkersResult listWorkers(ListWorkersRequest request) {
        request = (ListWorkersRequest)this.beforeClientExecution(request);
        return this.executeListWorkers(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListWorkersResult executeListWorkers(ListWorkersRequest listWorkersRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listWorkersRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListWorkersRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListWorkersRequestProtocolMarshaller(protocolFactory).marshall((ListWorkersRequest)super.beforeMarshalling((AmazonWebServiceRequest)listWorkersRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IoT RoboRunner");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListWorkers");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListWorkersResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListWorkersResult listWorkersResult = (ListWorkersResult)response.getAwsResponse();
            return listWorkersResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateDestinationResult updateDestination(UpdateDestinationRequest request) {
        request = (UpdateDestinationRequest)this.beforeClientExecution(request);
        return this.executeUpdateDestination(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateDestinationResult executeUpdateDestination(UpdateDestinationRequest updateDestinationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateDestinationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateDestinationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateDestinationRequestProtocolMarshaller(protocolFactory).marshall((UpdateDestinationRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateDestinationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IoT RoboRunner");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateDestination");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateDestinationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateDestinationResult updateDestinationResult = (UpdateDestinationResult)response.getAwsResponse();
            return updateDestinationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateSiteResult updateSite(UpdateSiteRequest request) {
        request = (UpdateSiteRequest)this.beforeClientExecution(request);
        return this.executeUpdateSite(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateSiteResult executeUpdateSite(UpdateSiteRequest updateSiteRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateSiteRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateSiteRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateSiteRequestProtocolMarshaller(protocolFactory).marshall((UpdateSiteRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateSiteRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IoT RoboRunner");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateSite");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateSiteResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateSiteResult updateSiteResult = (UpdateSiteResult)response.getAwsResponse();
            return updateSiteResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateWorkerResult updateWorker(UpdateWorkerRequest request) {
        request = (UpdateWorkerRequest)this.beforeClientExecution(request);
        return this.executeUpdateWorker(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateWorkerResult executeUpdateWorker(UpdateWorkerRequest updateWorkerRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateWorkerRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateWorkerRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateWorkerRequestProtocolMarshaller(protocolFactory).marshall((UpdateWorkerRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateWorkerRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IoT RoboRunner");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateWorker");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateWorkerResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateWorkerResult updateWorkerResult = (UpdateWorkerResult)response.getAwsResponse();
            return updateWorkerResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateWorkerFleetResult updateWorkerFleet(UpdateWorkerFleetRequest request) {
        request = (UpdateWorkerFleetRequest)this.beforeClientExecution(request);
        return this.executeUpdateWorkerFleet(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateWorkerFleetResult executeUpdateWorkerFleet(UpdateWorkerFleetRequest updateWorkerFleetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateWorkerFleetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateWorkerFleetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateWorkerFleetRequestProtocolMarshaller(protocolFactory).marshall((UpdateWorkerFleetRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateWorkerFleetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IoT RoboRunner");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateWorkerFleet");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateWorkerFleetResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateWorkerFleetResult updateWorkerFleetResult = (UpdateWorkerFleetResult)response.getAwsResponse();
            return updateWorkerFleetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }
}

