/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iotfleetwise.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.iotfleetwise.model.Node;
import com.amazonaws.services.iotfleetwise.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateSignalCatalogRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String name;
    private String description;
    private List<Node> nodes;
    private List<Tag> tags;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public CreateSignalCatalogRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public CreateSignalCatalogRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public List<Node> getNodes() {
        return this.nodes;
    }

    public void setNodes(Collection<Node> nodes) {
        if (nodes == null) {
            this.nodes = null;
            return;
        }
        this.nodes = new ArrayList<Node>(nodes);
    }

    public CreateSignalCatalogRequest withNodes(Node ... nodes) {
        if (this.nodes == null) {
            this.setNodes(new ArrayList<Node>(nodes.length));
        }
        for (Node ele : nodes) {
            this.nodes.add(ele);
        }
        return this;
    }

    public CreateSignalCatalogRequest withNodes(Collection<Node> nodes) {
        this.setNodes(nodes);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public CreateSignalCatalogRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreateSignalCatalogRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getNodes() != null) {
            sb.append("Nodes: ").append(this.getNodes()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSignalCatalogRequest)) {
            return false;
        }
        CreateSignalCatalogRequest other = (CreateSignalCatalogRequest)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getNodes() == null ^ this.getNodes() == null) {
            return false;
        }
        if (other.getNodes() != null && !other.getNodes().equals(this.getNodes())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getNodes() == null ? 0 : this.getNodes().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public CreateSignalCatalogRequest clone() {
        return (CreateSignalCatalogRequest)super.clone();
    }
}

