/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iotfleetwise.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.iotfleetwise.model.Tag;
import com.amazonaws.services.iotfleetwise.model.VehicleAssociationBehavior;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CreateVehicleRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String vehicleName;
    private String modelManifestArn;
    private String decoderManifestArn;
    private Map<String, String> attributes;
    private String associationBehavior;
    private List<Tag> tags;

    public void setVehicleName(String vehicleName) {
        this.vehicleName = vehicleName;
    }

    public String getVehicleName() {
        return this.vehicleName;
    }

    public CreateVehicleRequest withVehicleName(String vehicleName) {
        this.setVehicleName(vehicleName);
        return this;
    }

    public void setModelManifestArn(String modelManifestArn) {
        this.modelManifestArn = modelManifestArn;
    }

    public String getModelManifestArn() {
        return this.modelManifestArn;
    }

    public CreateVehicleRequest withModelManifestArn(String modelManifestArn) {
        this.setModelManifestArn(modelManifestArn);
        return this;
    }

    public void setDecoderManifestArn(String decoderManifestArn) {
        this.decoderManifestArn = decoderManifestArn;
    }

    public String getDecoderManifestArn() {
        return this.decoderManifestArn;
    }

    public CreateVehicleRequest withDecoderManifestArn(String decoderManifestArn) {
        this.setDecoderManifestArn(decoderManifestArn);
        return this;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public CreateVehicleRequest withAttributes(Map<String, String> attributes) {
        this.setAttributes(attributes);
        return this;
    }

    public CreateVehicleRequest addAttributesEntry(String key, String value) {
        if (null == this.attributes) {
            this.attributes = new HashMap<String, String>();
        }
        if (this.attributes.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.attributes.put(key, value);
        return this;
    }

    public CreateVehicleRequest clearAttributesEntries() {
        this.attributes = null;
        return this;
    }

    public void setAssociationBehavior(String associationBehavior) {
        this.associationBehavior = associationBehavior;
    }

    public String getAssociationBehavior() {
        return this.associationBehavior;
    }

    public CreateVehicleRequest withAssociationBehavior(String associationBehavior) {
        this.setAssociationBehavior(associationBehavior);
        return this;
    }

    public CreateVehicleRequest withAssociationBehavior(VehicleAssociationBehavior associationBehavior) {
        this.associationBehavior = associationBehavior.toString();
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public CreateVehicleRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreateVehicleRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getVehicleName() != null) {
            sb.append("VehicleName: ").append(this.getVehicleName()).append(",");
        }
        if (this.getModelManifestArn() != null) {
            sb.append("ModelManifestArn: ").append(this.getModelManifestArn()).append(",");
        }
        if (this.getDecoderManifestArn() != null) {
            sb.append("DecoderManifestArn: ").append(this.getDecoderManifestArn()).append(",");
        }
        if (this.getAttributes() != null) {
            sb.append("Attributes: ").append(this.getAttributes()).append(",");
        }
        if (this.getAssociationBehavior() != null) {
            sb.append("AssociationBehavior: ").append(this.getAssociationBehavior()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVehicleRequest)) {
            return false;
        }
        CreateVehicleRequest other = (CreateVehicleRequest)obj;
        if (other.getVehicleName() == null ^ this.getVehicleName() == null) {
            return false;
        }
        if (other.getVehicleName() != null && !other.getVehicleName().equals(this.getVehicleName())) {
            return false;
        }
        if (other.getModelManifestArn() == null ^ this.getModelManifestArn() == null) {
            return false;
        }
        if (other.getModelManifestArn() != null && !other.getModelManifestArn().equals(this.getModelManifestArn())) {
            return false;
        }
        if (other.getDecoderManifestArn() == null ^ this.getDecoderManifestArn() == null) {
            return false;
        }
        if (other.getDecoderManifestArn() != null && !other.getDecoderManifestArn().equals(this.getDecoderManifestArn())) {
            return false;
        }
        if (other.getAttributes() == null ^ this.getAttributes() == null) {
            return false;
        }
        if (other.getAttributes() != null && !other.getAttributes().equals(this.getAttributes())) {
            return false;
        }
        if (other.getAssociationBehavior() == null ^ this.getAssociationBehavior() == null) {
            return false;
        }
        if (other.getAssociationBehavior() != null && !other.getAssociationBehavior().equals(this.getAssociationBehavior())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getVehicleName() == null ? 0 : this.getVehicleName().hashCode());
        hashCode = 31 * hashCode + (this.getModelManifestArn() == null ? 0 : this.getModelManifestArn().hashCode());
        hashCode = 31 * hashCode + (this.getDecoderManifestArn() == null ? 0 : this.getDecoderManifestArn().hashCode());
        hashCode = 31 * hashCode + (this.getAttributes() == null ? 0 : this.getAttributes().hashCode());
        hashCode = 31 * hashCode + (this.getAssociationBehavior() == null ? 0 : this.getAssociationBehavior().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public CreateVehicleRequest clone() {
        return (CreateVehicleRequest)super.clone();
    }
}

