/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iotdeviceadvisor.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.iotdeviceadvisor.model.GroupResult;
import com.amazonaws.services.iotdeviceadvisor.model.transform.TestResultMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class TestResult
implements Serializable,
Cloneable,
StructuredPojo {
    private List<GroupResult> groups;

    public List<GroupResult> getGroups() {
        return this.groups;
    }

    public void setGroups(Collection<GroupResult> groups) {
        if (groups == null) {
            this.groups = null;
            return;
        }
        this.groups = new ArrayList<GroupResult>(groups);
    }

    public TestResult withGroups(GroupResult ... groups) {
        if (this.groups == null) {
            this.setGroups(new ArrayList<GroupResult>(groups.length));
        }
        for (GroupResult ele : groups) {
            this.groups.add(ele);
        }
        return this;
    }

    public TestResult withGroups(Collection<GroupResult> groups) {
        this.setGroups(groups);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getGroups() != null) {
            sb.append("Groups: ").append(this.getGroups());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestResult)) {
            return false;
        }
        TestResult other = (TestResult)obj;
        if (other.getGroups() == null ^ this.getGroups() == null) {
            return false;
        }
        return other.getGroups() == null || other.getGroups().equals(this.getGroups());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getGroups() == null ? 0 : this.getGroups().hashCode());
        return hashCode;
    }

    public TestResult clone() {
        try {
            return (TestResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TestResultMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

