/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iotanalytics.model.transform;

import com.amazonaws.services.iotanalytics.model.Datastore;
import com.amazonaws.services.iotanalytics.model.transform.DatastoreStorageJsonUnmarshaller;
import com.amazonaws.services.iotanalytics.model.transform.FileFormatConfigurationJsonUnmarshaller;
import com.amazonaws.services.iotanalytics.model.transform.RetentionPeriodJsonUnmarshaller;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers;
import com.amazonaws.transform.Unmarshaller;
import com.fasterxml.jackson.core.JsonToken;

public class DatastoreJsonUnmarshaller
implements Unmarshaller<Datastore, JsonUnmarshallerContext> {
    private static DatastoreJsonUnmarshaller instance;

    public Datastore unmarshall(JsonUnmarshallerContext context) throws Exception {
        Datastore datastore = new Datastore();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("name", targetDepth)) {
                    context.nextToken();
                    datastore.setName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("storage", targetDepth)) {
                    context.nextToken();
                    datastore.setStorage(DatastoreStorageJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("arn", targetDepth)) {
                    context.nextToken();
                    datastore.setArn((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("status", targetDepth)) {
                    context.nextToken();
                    datastore.setStatus((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("retentionPeriod", targetDepth)) {
                    context.nextToken();
                    datastore.setRetentionPeriod(RetentionPeriodJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("creationTime", targetDepth)) {
                    context.nextToken();
                    datastore.setCreationTime(SimpleTypeJsonUnmarshallers.DateJsonUnmarshallerFactory.getInstance((String)"unixTimestamp").unmarshall(context));
                }
                if (context.testExpression("lastUpdateTime", targetDepth)) {
                    context.nextToken();
                    datastore.setLastUpdateTime(SimpleTypeJsonUnmarshallers.DateJsonUnmarshallerFactory.getInstance((String)"unixTimestamp").unmarshall(context));
                }
                if (context.testExpression("lastMessageArrivalTime", targetDepth)) {
                    context.nextToken();
                    datastore.setLastMessageArrivalTime(SimpleTypeJsonUnmarshallers.DateJsonUnmarshallerFactory.getInstance((String)"unixTimestamp").unmarshall(context));
                }
                if (context.testExpression("fileFormatConfiguration", targetDepth)) {
                    context.nextToken();
                    datastore.setFileFormatConfiguration(FileFormatConfigurationJsonUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return datastore;
    }

    public static DatastoreJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new DatastoreJsonUnmarshaller();
        }
        return instance;
    }
}

