/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.iot.model.KafkaActionHeader;
import com.amazonaws.services.iot.model.transform.KafkaActionMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class KafkaAction
implements Serializable,
Cloneable,
StructuredPojo {
    private String destinationArn;
    private String topic;
    private String key;
    private String partition;
    private Map<String, String> clientProperties;
    private List<KafkaActionHeader> headers;

    public void setDestinationArn(String destinationArn) {
        this.destinationArn = destinationArn;
    }

    public String getDestinationArn() {
        return this.destinationArn;
    }

    public KafkaAction withDestinationArn(String destinationArn) {
        this.setDestinationArn(destinationArn);
        return this;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public String getTopic() {
        return this.topic;
    }

    public KafkaAction withTopic(String topic) {
        this.setTopic(topic);
        return this;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public KafkaAction withKey(String key) {
        this.setKey(key);
        return this;
    }

    public void setPartition(String partition) {
        this.partition = partition;
    }

    public String getPartition() {
        return this.partition;
    }

    public KafkaAction withPartition(String partition) {
        this.setPartition(partition);
        return this;
    }

    public Map<String, String> getClientProperties() {
        return this.clientProperties;
    }

    public void setClientProperties(Map<String, String> clientProperties) {
        this.clientProperties = clientProperties;
    }

    public KafkaAction withClientProperties(Map<String, String> clientProperties) {
        this.setClientProperties(clientProperties);
        return this;
    }

    public KafkaAction addClientPropertiesEntry(String key, String value) {
        if (null == this.clientProperties) {
            this.clientProperties = new HashMap<String, String>();
        }
        if (this.clientProperties.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.clientProperties.put(key, value);
        return this;
    }

    public KafkaAction clearClientPropertiesEntries() {
        this.clientProperties = null;
        return this;
    }

    public List<KafkaActionHeader> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Collection<KafkaActionHeader> headers) {
        if (headers == null) {
            this.headers = null;
            return;
        }
        this.headers = new ArrayList<KafkaActionHeader>(headers);
    }

    public KafkaAction withHeaders(KafkaActionHeader ... headers) {
        if (this.headers == null) {
            this.setHeaders(new ArrayList<KafkaActionHeader>(headers.length));
        }
        for (KafkaActionHeader ele : headers) {
            this.headers.add(ele);
        }
        return this;
    }

    public KafkaAction withHeaders(Collection<KafkaActionHeader> headers) {
        this.setHeaders(headers);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDestinationArn() != null) {
            sb.append("DestinationArn: ").append(this.getDestinationArn()).append(",");
        }
        if (this.getTopic() != null) {
            sb.append("Topic: ").append(this.getTopic()).append(",");
        }
        if (this.getKey() != null) {
            sb.append("Key: ").append(this.getKey()).append(",");
        }
        if (this.getPartition() != null) {
            sb.append("Partition: ").append(this.getPartition()).append(",");
        }
        if (this.getClientProperties() != null) {
            sb.append("ClientProperties: ").append(this.getClientProperties()).append(",");
        }
        if (this.getHeaders() != null) {
            sb.append("Headers: ").append(this.getHeaders());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KafkaAction)) {
            return false;
        }
        KafkaAction other = (KafkaAction)obj;
        if (other.getDestinationArn() == null ^ this.getDestinationArn() == null) {
            return false;
        }
        if (other.getDestinationArn() != null && !other.getDestinationArn().equals(this.getDestinationArn())) {
            return false;
        }
        if (other.getTopic() == null ^ this.getTopic() == null) {
            return false;
        }
        if (other.getTopic() != null && !other.getTopic().equals(this.getTopic())) {
            return false;
        }
        if (other.getKey() == null ^ this.getKey() == null) {
            return false;
        }
        if (other.getKey() != null && !other.getKey().equals(this.getKey())) {
            return false;
        }
        if (other.getPartition() == null ^ this.getPartition() == null) {
            return false;
        }
        if (other.getPartition() != null && !other.getPartition().equals(this.getPartition())) {
            return false;
        }
        if (other.getClientProperties() == null ^ this.getClientProperties() == null) {
            return false;
        }
        if (other.getClientProperties() != null && !other.getClientProperties().equals(this.getClientProperties())) {
            return false;
        }
        if (other.getHeaders() == null ^ this.getHeaders() == null) {
            return false;
        }
        return other.getHeaders() == null || other.getHeaders().equals(this.getHeaders());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDestinationArn() == null ? 0 : this.getDestinationArn().hashCode());
        hashCode = 31 * hashCode + (this.getTopic() == null ? 0 : this.getTopic().hashCode());
        hashCode = 31 * hashCode + (this.getKey() == null ? 0 : this.getKey().hashCode());
        hashCode = 31 * hashCode + (this.getPartition() == null ? 0 : this.getPartition().hashCode());
        hashCode = 31 * hashCode + (this.getClientProperties() == null ? 0 : this.getClientProperties().hashCode());
        hashCode = 31 * hashCode + (this.getHeaders() == null ? 0 : this.getHeaders().hashCode());
        return hashCode;
    }

    public KafkaAction clone() {
        try {
            return (KafkaAction)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        KafkaActionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

