/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.iot.model.AuditFindingSeverity;
import com.amazonaws.services.iot.model.NonCompliantResource;
import com.amazonaws.services.iot.model.RelatedResource;
import com.amazonaws.services.iot.model.transform.AuditFindingMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class AuditFinding
implements Serializable,
Cloneable,
StructuredPojo {
    private String findingId;
    private String taskId;
    private String checkName;
    private Date taskStartTime;
    private Date findingTime;
    private String severity;
    private NonCompliantResource nonCompliantResource;
    private List<RelatedResource> relatedResources;
    private String reasonForNonCompliance;
    private String reasonForNonComplianceCode;
    private Boolean isSuppressed;

    public void setFindingId(String findingId) {
        this.findingId = findingId;
    }

    public String getFindingId() {
        return this.findingId;
    }

    public AuditFinding withFindingId(String findingId) {
        this.setFindingId(findingId);
        return this;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public AuditFinding withTaskId(String taskId) {
        this.setTaskId(taskId);
        return this;
    }

    public void setCheckName(String checkName) {
        this.checkName = checkName;
    }

    public String getCheckName() {
        return this.checkName;
    }

    public AuditFinding withCheckName(String checkName) {
        this.setCheckName(checkName);
        return this;
    }

    public void setTaskStartTime(Date taskStartTime) {
        this.taskStartTime = taskStartTime;
    }

    public Date getTaskStartTime() {
        return this.taskStartTime;
    }

    public AuditFinding withTaskStartTime(Date taskStartTime) {
        this.setTaskStartTime(taskStartTime);
        return this;
    }

    public void setFindingTime(Date findingTime) {
        this.findingTime = findingTime;
    }

    public Date getFindingTime() {
        return this.findingTime;
    }

    public AuditFinding withFindingTime(Date findingTime) {
        this.setFindingTime(findingTime);
        return this;
    }

    public void setSeverity(String severity) {
        this.severity = severity;
    }

    public String getSeverity() {
        return this.severity;
    }

    public AuditFinding withSeverity(String severity) {
        this.setSeverity(severity);
        return this;
    }

    public AuditFinding withSeverity(AuditFindingSeverity severity) {
        this.severity = severity.toString();
        return this;
    }

    public void setNonCompliantResource(NonCompliantResource nonCompliantResource) {
        this.nonCompliantResource = nonCompliantResource;
    }

    public NonCompliantResource getNonCompliantResource() {
        return this.nonCompliantResource;
    }

    public AuditFinding withNonCompliantResource(NonCompliantResource nonCompliantResource) {
        this.setNonCompliantResource(nonCompliantResource);
        return this;
    }

    public List<RelatedResource> getRelatedResources() {
        return this.relatedResources;
    }

    public void setRelatedResources(Collection<RelatedResource> relatedResources) {
        if (relatedResources == null) {
            this.relatedResources = null;
            return;
        }
        this.relatedResources = new ArrayList<RelatedResource>(relatedResources);
    }

    public AuditFinding withRelatedResources(RelatedResource ... relatedResources) {
        if (this.relatedResources == null) {
            this.setRelatedResources(new ArrayList<RelatedResource>(relatedResources.length));
        }
        for (RelatedResource ele : relatedResources) {
            this.relatedResources.add(ele);
        }
        return this;
    }

    public AuditFinding withRelatedResources(Collection<RelatedResource> relatedResources) {
        this.setRelatedResources(relatedResources);
        return this;
    }

    public void setReasonForNonCompliance(String reasonForNonCompliance) {
        this.reasonForNonCompliance = reasonForNonCompliance;
    }

    public String getReasonForNonCompliance() {
        return this.reasonForNonCompliance;
    }

    public AuditFinding withReasonForNonCompliance(String reasonForNonCompliance) {
        this.setReasonForNonCompliance(reasonForNonCompliance);
        return this;
    }

    public void setReasonForNonComplianceCode(String reasonForNonComplianceCode) {
        this.reasonForNonComplianceCode = reasonForNonComplianceCode;
    }

    public String getReasonForNonComplianceCode() {
        return this.reasonForNonComplianceCode;
    }

    public AuditFinding withReasonForNonComplianceCode(String reasonForNonComplianceCode) {
        this.setReasonForNonComplianceCode(reasonForNonComplianceCode);
        return this;
    }

    public void setIsSuppressed(Boolean isSuppressed) {
        this.isSuppressed = isSuppressed;
    }

    public Boolean getIsSuppressed() {
        return this.isSuppressed;
    }

    public AuditFinding withIsSuppressed(Boolean isSuppressed) {
        this.setIsSuppressed(isSuppressed);
        return this;
    }

    public Boolean isSuppressed() {
        return this.isSuppressed;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFindingId() != null) {
            sb.append("FindingId: ").append(this.getFindingId()).append(",");
        }
        if (this.getTaskId() != null) {
            sb.append("TaskId: ").append(this.getTaskId()).append(",");
        }
        if (this.getCheckName() != null) {
            sb.append("CheckName: ").append(this.getCheckName()).append(",");
        }
        if (this.getTaskStartTime() != null) {
            sb.append("TaskStartTime: ").append(this.getTaskStartTime()).append(",");
        }
        if (this.getFindingTime() != null) {
            sb.append("FindingTime: ").append(this.getFindingTime()).append(",");
        }
        if (this.getSeverity() != null) {
            sb.append("Severity: ").append(this.getSeverity()).append(",");
        }
        if (this.getNonCompliantResource() != null) {
            sb.append("NonCompliantResource: ").append(this.getNonCompliantResource()).append(",");
        }
        if (this.getRelatedResources() != null) {
            sb.append("RelatedResources: ").append(this.getRelatedResources()).append(",");
        }
        if (this.getReasonForNonCompliance() != null) {
            sb.append("ReasonForNonCompliance: ").append(this.getReasonForNonCompliance()).append(",");
        }
        if (this.getReasonForNonComplianceCode() != null) {
            sb.append("ReasonForNonComplianceCode: ").append(this.getReasonForNonComplianceCode()).append(",");
        }
        if (this.getIsSuppressed() != null) {
            sb.append("IsSuppressed: ").append(this.getIsSuppressed());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuditFinding)) {
            return false;
        }
        AuditFinding other = (AuditFinding)obj;
        if (other.getFindingId() == null ^ this.getFindingId() == null) {
            return false;
        }
        if (other.getFindingId() != null && !other.getFindingId().equals(this.getFindingId())) {
            return false;
        }
        if (other.getTaskId() == null ^ this.getTaskId() == null) {
            return false;
        }
        if (other.getTaskId() != null && !other.getTaskId().equals(this.getTaskId())) {
            return false;
        }
        if (other.getCheckName() == null ^ this.getCheckName() == null) {
            return false;
        }
        if (other.getCheckName() != null && !other.getCheckName().equals(this.getCheckName())) {
            return false;
        }
        if (other.getTaskStartTime() == null ^ this.getTaskStartTime() == null) {
            return false;
        }
        if (other.getTaskStartTime() != null && !other.getTaskStartTime().equals(this.getTaskStartTime())) {
            return false;
        }
        if (other.getFindingTime() == null ^ this.getFindingTime() == null) {
            return false;
        }
        if (other.getFindingTime() != null && !other.getFindingTime().equals(this.getFindingTime())) {
            return false;
        }
        if (other.getSeverity() == null ^ this.getSeverity() == null) {
            return false;
        }
        if (other.getSeverity() != null && !other.getSeverity().equals(this.getSeverity())) {
            return false;
        }
        if (other.getNonCompliantResource() == null ^ this.getNonCompliantResource() == null) {
            return false;
        }
        if (other.getNonCompliantResource() != null && !other.getNonCompliantResource().equals(this.getNonCompliantResource())) {
            return false;
        }
        if (other.getRelatedResources() == null ^ this.getRelatedResources() == null) {
            return false;
        }
        if (other.getRelatedResources() != null && !other.getRelatedResources().equals(this.getRelatedResources())) {
            return false;
        }
        if (other.getReasonForNonCompliance() == null ^ this.getReasonForNonCompliance() == null) {
            return false;
        }
        if (other.getReasonForNonCompliance() != null && !other.getReasonForNonCompliance().equals(this.getReasonForNonCompliance())) {
            return false;
        }
        if (other.getReasonForNonComplianceCode() == null ^ this.getReasonForNonComplianceCode() == null) {
            return false;
        }
        if (other.getReasonForNonComplianceCode() != null && !other.getReasonForNonComplianceCode().equals(this.getReasonForNonComplianceCode())) {
            return false;
        }
        if (other.getIsSuppressed() == null ^ this.getIsSuppressed() == null) {
            return false;
        }
        return other.getIsSuppressed() == null || other.getIsSuppressed().equals(this.getIsSuppressed());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFindingId() == null ? 0 : this.getFindingId().hashCode());
        hashCode = 31 * hashCode + (this.getTaskId() == null ? 0 : this.getTaskId().hashCode());
        hashCode = 31 * hashCode + (this.getCheckName() == null ? 0 : this.getCheckName().hashCode());
        hashCode = 31 * hashCode + (this.getTaskStartTime() == null ? 0 : this.getTaskStartTime().hashCode());
        hashCode = 31 * hashCode + (this.getFindingTime() == null ? 0 : this.getFindingTime().hashCode());
        hashCode = 31 * hashCode + (this.getSeverity() == null ? 0 : this.getSeverity().hashCode());
        hashCode = 31 * hashCode + (this.getNonCompliantResource() == null ? 0 : this.getNonCompliantResource().hashCode());
        hashCode = 31 * hashCode + (this.getRelatedResources() == null ? 0 : this.getRelatedResources().hashCode());
        hashCode = 31 * hashCode + (this.getReasonForNonCompliance() == null ? 0 : this.getReasonForNonCompliance().hashCode());
        hashCode = 31 * hashCode + (this.getReasonForNonComplianceCode() == null ? 0 : this.getReasonForNonComplianceCode().hashCode());
        hashCode = 31 * hashCode + (this.getIsSuppressed() == null ? 0 : this.getIsSuppressed().hashCode());
        return hashCode;
    }

    public AuditFinding clone() {
        try {
            return (AuditFinding)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AuditFindingMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

