/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.imagebuilder.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.imagebuilder.model.DiskImageFormat;
import com.amazonaws.services.imagebuilder.model.transform.S3ExportConfigurationMarshaller;
import java.io.Serializable;

public class S3ExportConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private String roleName;
    private String diskImageFormat;
    private String s3Bucket;
    private String s3Prefix;

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    public String getRoleName() {
        return this.roleName;
    }

    public S3ExportConfiguration withRoleName(String roleName) {
        this.setRoleName(roleName);
        return this;
    }

    public void setDiskImageFormat(String diskImageFormat) {
        this.diskImageFormat = diskImageFormat;
    }

    public String getDiskImageFormat() {
        return this.diskImageFormat;
    }

    public S3ExportConfiguration withDiskImageFormat(String diskImageFormat) {
        this.setDiskImageFormat(diskImageFormat);
        return this;
    }

    public S3ExportConfiguration withDiskImageFormat(DiskImageFormat diskImageFormat) {
        this.diskImageFormat = diskImageFormat.toString();
        return this;
    }

    public void setS3Bucket(String s3Bucket) {
        this.s3Bucket = s3Bucket;
    }

    public String getS3Bucket() {
        return this.s3Bucket;
    }

    public S3ExportConfiguration withS3Bucket(String s3Bucket) {
        this.setS3Bucket(s3Bucket);
        return this;
    }

    public void setS3Prefix(String s3Prefix) {
        this.s3Prefix = s3Prefix;
    }

    public String getS3Prefix() {
        return this.s3Prefix;
    }

    public S3ExportConfiguration withS3Prefix(String s3Prefix) {
        this.setS3Prefix(s3Prefix);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getRoleName() != null) {
            sb.append("RoleName: ").append(this.getRoleName()).append(",");
        }
        if (this.getDiskImageFormat() != null) {
            sb.append("DiskImageFormat: ").append(this.getDiskImageFormat()).append(",");
        }
        if (this.getS3Bucket() != null) {
            sb.append("S3Bucket: ").append(this.getS3Bucket()).append(",");
        }
        if (this.getS3Prefix() != null) {
            sb.append("S3Prefix: ").append(this.getS3Prefix());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3ExportConfiguration)) {
            return false;
        }
        S3ExportConfiguration other = (S3ExportConfiguration)obj;
        if (other.getRoleName() == null ^ this.getRoleName() == null) {
            return false;
        }
        if (other.getRoleName() != null && !other.getRoleName().equals(this.getRoleName())) {
            return false;
        }
        if (other.getDiskImageFormat() == null ^ this.getDiskImageFormat() == null) {
            return false;
        }
        if (other.getDiskImageFormat() != null && !other.getDiskImageFormat().equals(this.getDiskImageFormat())) {
            return false;
        }
        if (other.getS3Bucket() == null ^ this.getS3Bucket() == null) {
            return false;
        }
        if (other.getS3Bucket() != null && !other.getS3Bucket().equals(this.getS3Bucket())) {
            return false;
        }
        if (other.getS3Prefix() == null ^ this.getS3Prefix() == null) {
            return false;
        }
        return other.getS3Prefix() == null || other.getS3Prefix().equals(this.getS3Prefix());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getRoleName() == null ? 0 : this.getRoleName().hashCode());
        hashCode = 31 * hashCode + (this.getDiskImageFormat() == null ? 0 : this.getDiskImageFormat().hashCode());
        hashCode = 31 * hashCode + (this.getS3Bucket() == null ? 0 : this.getS3Bucket().hashCode());
        hashCode = 31 * hashCode + (this.getS3Prefix() == null ? 0 : this.getS3Prefix().hashCode());
        return hashCode;
    }

    public S3ExportConfiguration clone() {
        try {
            return (S3ExportConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        S3ExportConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

