/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.imagebuilder.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.imagebuilder.model.TargetContainerRepository;
import com.amazonaws.services.imagebuilder.model.transform.ContainerDistributionConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ContainerDistributionConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private String description;
    private List<String> containerTags;
    private TargetContainerRepository targetRepository;

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public ContainerDistributionConfiguration withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public List<String> getContainerTags() {
        return this.containerTags;
    }

    public void setContainerTags(Collection<String> containerTags) {
        if (containerTags == null) {
            this.containerTags = null;
            return;
        }
        this.containerTags = new ArrayList<String>(containerTags);
    }

    public ContainerDistributionConfiguration withContainerTags(String ... containerTags) {
        if (this.containerTags == null) {
            this.setContainerTags(new ArrayList<String>(containerTags.length));
        }
        for (String ele : containerTags) {
            this.containerTags.add(ele);
        }
        return this;
    }

    public ContainerDistributionConfiguration withContainerTags(Collection<String> containerTags) {
        this.setContainerTags(containerTags);
        return this;
    }

    public void setTargetRepository(TargetContainerRepository targetRepository) {
        this.targetRepository = targetRepository;
    }

    public TargetContainerRepository getTargetRepository() {
        return this.targetRepository;
    }

    public ContainerDistributionConfiguration withTargetRepository(TargetContainerRepository targetRepository) {
        this.setTargetRepository(targetRepository);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getContainerTags() != null) {
            sb.append("ContainerTags: ").append(this.getContainerTags()).append(",");
        }
        if (this.getTargetRepository() != null) {
            sb.append("TargetRepository: ").append(this.getTargetRepository());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContainerDistributionConfiguration)) {
            return false;
        }
        ContainerDistributionConfiguration other = (ContainerDistributionConfiguration)obj;
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getContainerTags() == null ^ this.getContainerTags() == null) {
            return false;
        }
        if (other.getContainerTags() != null && !other.getContainerTags().equals(this.getContainerTags())) {
            return false;
        }
        if (other.getTargetRepository() == null ^ this.getTargetRepository() == null) {
            return false;
        }
        return other.getTargetRepository() == null || other.getTargetRepository().equals(this.getTargetRepository());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getContainerTags() == null ? 0 : this.getContainerTags().hashCode());
        hashCode = 31 * hashCode + (this.getTargetRepository() == null ? 0 : this.getTargetRepository().hashCode());
        return hashCode;
    }

    public ContainerDistributionConfiguration clone() {
        try {
            return (ContainerDistributionConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ContainerDistributionConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

