/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.identitystore.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.identitystore.model.User;
import java.util.List;

@SdkInternalApi
public class UserMarshaller {
    private static final MarshallingInfo<String> USERNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UserName").build();
    private static final MarshallingInfo<String> USERID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UserId").build();
    private static final MarshallingInfo<List> EXTERNALIDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExternalIds").build();
    private static final MarshallingInfo<StructuredPojo> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final MarshallingInfo<String> DISPLAYNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DisplayName").build();
    private static final MarshallingInfo<String> NICKNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NickName").build();
    private static final MarshallingInfo<String> PROFILEURL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProfileUrl").build();
    private static final MarshallingInfo<List> EMAILS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Emails").build();
    private static final MarshallingInfo<List> ADDRESSES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Addresses").build();
    private static final MarshallingInfo<List> PHONENUMBERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PhoneNumbers").build();
    private static final MarshallingInfo<String> USERTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UserType").build();
    private static final MarshallingInfo<String> TITLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Title").build();
    private static final MarshallingInfo<String> PREFERREDLANGUAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PreferredLanguage").build();
    private static final MarshallingInfo<String> LOCALE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Locale").build();
    private static final MarshallingInfo<String> TIMEZONE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Timezone").build();
    private static final MarshallingInfo<String> IDENTITYSTOREID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IdentityStoreId").build();
    private static final UserMarshaller instance = new UserMarshaller();

    public static UserMarshaller getInstance() {
        return instance;
    }

    public void marshall(User user, ProtocolMarshaller protocolMarshaller) {
        if (user == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)user.getUserName(), USERNAME_BINDING);
            protocolMarshaller.marshall((Object)user.getUserId(), USERID_BINDING);
            protocolMarshaller.marshall(user.getExternalIds(), EXTERNALIDS_BINDING);
            protocolMarshaller.marshall((Object)user.getName(), NAME_BINDING);
            protocolMarshaller.marshall((Object)user.getDisplayName(), DISPLAYNAME_BINDING);
            protocolMarshaller.marshall((Object)user.getNickName(), NICKNAME_BINDING);
            protocolMarshaller.marshall((Object)user.getProfileUrl(), PROFILEURL_BINDING);
            protocolMarshaller.marshall(user.getEmails(), EMAILS_BINDING);
            protocolMarshaller.marshall(user.getAddresses(), ADDRESSES_BINDING);
            protocolMarshaller.marshall(user.getPhoneNumbers(), PHONENUMBERS_BINDING);
            protocolMarshaller.marshall((Object)user.getUserType(), USERTYPE_BINDING);
            protocolMarshaller.marshall((Object)user.getTitle(), TITLE_BINDING);
            protocolMarshaller.marshall((Object)user.getPreferredLanguage(), PREFERREDLANGUAGE_BINDING);
            protocolMarshaller.marshall((Object)user.getLocale(), LOCALE_BINDING);
            protocolMarshaller.marshall((Object)user.getTimezone(), TIMEZONE_BINDING);
            protocolMarshaller.marshall((Object)user.getIdentityStoreId(), IDENTITYSTOREID_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

