/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.identitystore.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.identitystore.model.ExternalId;
import com.amazonaws.services.identitystore.model.transform.GroupMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Group
implements Serializable,
Cloneable,
StructuredPojo {
    private String groupId;
    private String displayName;
    private List<ExternalId> externalIds;
    private String description;
    private String identityStoreId;

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public Group withGroupId(String groupId) {
        this.setGroupId(groupId);
        return this;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Group withDisplayName(String displayName) {
        this.setDisplayName(displayName);
        return this;
    }

    public List<ExternalId> getExternalIds() {
        return this.externalIds;
    }

    public void setExternalIds(Collection<ExternalId> externalIds) {
        if (externalIds == null) {
            this.externalIds = null;
            return;
        }
        this.externalIds = new ArrayList<ExternalId>(externalIds);
    }

    public Group withExternalIds(ExternalId ... externalIds) {
        if (this.externalIds == null) {
            this.setExternalIds(new ArrayList<ExternalId>(externalIds.length));
        }
        for (ExternalId ele : externalIds) {
            this.externalIds.add(ele);
        }
        return this;
    }

    public Group withExternalIds(Collection<ExternalId> externalIds) {
        this.setExternalIds(externalIds);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public Group withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setIdentityStoreId(String identityStoreId) {
        this.identityStoreId = identityStoreId;
    }

    public String getIdentityStoreId() {
        return this.identityStoreId;
    }

    public Group withIdentityStoreId(String identityStoreId) {
        this.setIdentityStoreId(identityStoreId);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getGroupId() != null) {
            sb.append("GroupId: ").append(this.getGroupId()).append(",");
        }
        if (this.getDisplayName() != null) {
            sb.append("DisplayName: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getExternalIds() != null) {
            sb.append("ExternalIds: ").append(this.getExternalIds()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getIdentityStoreId() != null) {
            sb.append("IdentityStoreId: ").append(this.getIdentityStoreId());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Group)) {
            return false;
        }
        Group other = (Group)obj;
        if (other.getGroupId() == null ^ this.getGroupId() == null) {
            return false;
        }
        if (other.getGroupId() != null && !other.getGroupId().equals(this.getGroupId())) {
            return false;
        }
        if (other.getDisplayName() == null ^ this.getDisplayName() == null) {
            return false;
        }
        if (other.getDisplayName() != null && !other.getDisplayName().equals(this.getDisplayName())) {
            return false;
        }
        if (other.getExternalIds() == null ^ this.getExternalIds() == null) {
            return false;
        }
        if (other.getExternalIds() != null && !other.getExternalIds().equals(this.getExternalIds())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getIdentityStoreId() == null ^ this.getIdentityStoreId() == null) {
            return false;
        }
        return other.getIdentityStoreId() == null || other.getIdentityStoreId().equals(this.getIdentityStoreId());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getGroupId() == null ? 0 : this.getGroupId().hashCode());
        hashCode = 31 * hashCode + (this.getDisplayName() == null ? 0 : this.getDisplayName().hashCode());
        hashCode = 31 * hashCode + (this.getExternalIds() == null ? 0 : this.getExternalIds().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getIdentityStoreId() == null ? 0 : this.getIdentityStoreId().hashCode());
        return hashCode;
    }

    public Group clone() {
        try {
            return (Group)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        GroupMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

