/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.identitymanagement.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.identitymanagement.model.Tag;
import com.amazonaws.services.identitymanagement.model.TagPolicyRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class TagPolicyRequestMarshaller
implements Marshaller<Request<TagPolicyRequest>, TagPolicyRequest> {
    public Request<TagPolicyRequest> marshall(TagPolicyRequest tagPolicyRequest) {
        if (tagPolicyRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)tagPolicyRequest, "AmazonIdentityManagement");
        request.addParameter("Action", "TagPolicy");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (tagPolicyRequest.getPolicyArn() != null) {
            request.addParameter("PolicyArn", StringUtils.fromString((String)tagPolicyRequest.getPolicyArn()));
        }
        if (!tagPolicyRequest.getTags().isEmpty() || !((SdkInternalList)tagPolicyRequest.getTags()).isAutoConstruct()) {
            SdkInternalList tagsList = (SdkInternalList)tagPolicyRequest.getTags();
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue != null) {
                    if (tagsListValue.getKey() != null) {
                        request.addParameter("Tags.member." + tagsListIndex + ".Key", StringUtils.fromString((String)tagsListValue.getKey()));
                    }
                    if (tagsListValue.getValue() != null) {
                        request.addParameter("Tags.member." + tagsListIndex + ".Value", StringUtils.fromString((String)tagsListValue.getValue()));
                    }
                }
                ++tagsListIndex;
            }
        }
        return request;
    }
}

