/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.guardduty.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.guardduty.model.DataSourceConfigurationsResult;
import com.amazonaws.services.guardduty.model.MemberFeaturesConfigurationResult;
import com.amazonaws.services.guardduty.model.transform.MemberDataSourceConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class MemberDataSourceConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private String accountId;
    @Deprecated
    private DataSourceConfigurationsResult dataSources;
    private List<MemberFeaturesConfigurationResult> features;

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public MemberDataSourceConfiguration withAccountId(String accountId) {
        this.setAccountId(accountId);
        return this;
    }

    @Deprecated
    public void setDataSources(DataSourceConfigurationsResult dataSources) {
        this.dataSources = dataSources;
    }

    @Deprecated
    public DataSourceConfigurationsResult getDataSources() {
        return this.dataSources;
    }

    @Deprecated
    public MemberDataSourceConfiguration withDataSources(DataSourceConfigurationsResult dataSources) {
        this.setDataSources(dataSources);
        return this;
    }

    public List<MemberFeaturesConfigurationResult> getFeatures() {
        return this.features;
    }

    public void setFeatures(Collection<MemberFeaturesConfigurationResult> features) {
        if (features == null) {
            this.features = null;
            return;
        }
        this.features = new ArrayList<MemberFeaturesConfigurationResult>(features);
    }

    public MemberDataSourceConfiguration withFeatures(MemberFeaturesConfigurationResult ... features) {
        if (this.features == null) {
            this.setFeatures(new ArrayList<MemberFeaturesConfigurationResult>(features.length));
        }
        for (MemberFeaturesConfigurationResult ele : features) {
            this.features.add(ele);
        }
        return this;
    }

    public MemberDataSourceConfiguration withFeatures(Collection<MemberFeaturesConfigurationResult> features) {
        this.setFeatures(features);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAccountId() != null) {
            sb.append("AccountId: ").append(this.getAccountId()).append(",");
        }
        if (this.getDataSources() != null) {
            sb.append("DataSources: ").append(this.getDataSources()).append(",");
        }
        if (this.getFeatures() != null) {
            sb.append("Features: ").append(this.getFeatures());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MemberDataSourceConfiguration)) {
            return false;
        }
        MemberDataSourceConfiguration other = (MemberDataSourceConfiguration)obj;
        if (other.getAccountId() == null ^ this.getAccountId() == null) {
            return false;
        }
        if (other.getAccountId() != null && !other.getAccountId().equals(this.getAccountId())) {
            return false;
        }
        if (other.getDataSources() == null ^ this.getDataSources() == null) {
            return false;
        }
        if (other.getDataSources() != null && !other.getDataSources().equals(this.getDataSources())) {
            return false;
        }
        if (other.getFeatures() == null ^ this.getFeatures() == null) {
            return false;
        }
        return other.getFeatures() == null || other.getFeatures().equals(this.getFeatures());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAccountId() == null ? 0 : this.getAccountId().hashCode());
        hashCode = 31 * hashCode + (this.getDataSources() == null ? 0 : this.getDataSources().hashCode());
        hashCode = 31 * hashCode + (this.getFeatures() == null ? 0 : this.getFeatures().hashCode());
        return hashCode;
    }

    public MemberDataSourceConfiguration clone() {
        try {
            return (MemberDataSourceConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MemberDataSourceConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

