/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.guardduty.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/StartMalwareScan" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class StartMalwareScanResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable, Cloneable {

    /**
     * <p>
     * A unique identifier that gets generated when you invoke the API without any error. Each malware scan has a
     * corresponding scan ID. Using this scan ID, you can monitor the status of your malware scan.
     * </p>
     */
    private String scanId;

    /**
     * <p>
     * A unique identifier that gets generated when you invoke the API without any error. Each malware scan has a
     * corresponding scan ID. Using this scan ID, you can monitor the status of your malware scan.
     * </p>
     * 
     * @param scanId
     *        A unique identifier that gets generated when you invoke the API without any error. Each malware scan has a
     *        corresponding scan ID. Using this scan ID, you can monitor the status of your malware scan.
     */

    public void setScanId(String scanId) {
        this.scanId = scanId;
    }

    /**
     * <p>
     * A unique identifier that gets generated when you invoke the API without any error. Each malware scan has a
     * corresponding scan ID. Using this scan ID, you can monitor the status of your malware scan.
     * </p>
     * 
     * @return A unique identifier that gets generated when you invoke the API without any error. Each malware scan has
     *         a corresponding scan ID. Using this scan ID, you can monitor the status of your malware scan.
     */

    public String getScanId() {
        return this.scanId;
    }

    /**
     * <p>
     * A unique identifier that gets generated when you invoke the API without any error. Each malware scan has a
     * corresponding scan ID. Using this scan ID, you can monitor the status of your malware scan.
     * </p>
     * 
     * @param scanId
     *        A unique identifier that gets generated when you invoke the API without any error. Each malware scan has a
     *        corresponding scan ID. Using this scan ID, you can monitor the status of your malware scan.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public StartMalwareScanResult withScanId(String scanId) {
        setScanId(scanId);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getScanId() != null)
            sb.append("ScanId: ").append(getScanId());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof StartMalwareScanResult == false)
            return false;
        StartMalwareScanResult other = (StartMalwareScanResult) obj;
        if (other.getScanId() == null ^ this.getScanId() == null)
            return false;
        if (other.getScanId() != null && other.getScanId().equals(this.getScanId()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getScanId() == null) ? 0 : getScanId().hashCode());
        return hashCode;
    }

    @Override
    public StartMalwareScanResult clone() {
        try {
            return (StartMalwareScanResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
