/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.groundstation.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.groundstation.model.SatelliteListItem;
import java.util.List;

@SdkInternalApi
public class SatelliteListItemMarshaller {
    private static final MarshallingInfo<StructuredPojo> CURRENTEPHEMERIS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("currentEphemeris").build();
    private static final MarshallingInfo<List> GROUNDSTATIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("groundStations").build();
    private static final MarshallingInfo<Integer> NORADSATELLITEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("noradSatelliteID").build();
    private static final MarshallingInfo<String> SATELLITEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("satelliteArn").build();
    private static final MarshallingInfo<String> SATELLITEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("satelliteId").build();
    private static final SatelliteListItemMarshaller instance = new SatelliteListItemMarshaller();

    public static SatelliteListItemMarshaller getInstance() {
        return instance;
    }

    public void marshall(SatelliteListItem satelliteListItem, ProtocolMarshaller protocolMarshaller) {
        if (satelliteListItem == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)satelliteListItem.getCurrentEphemeris(), CURRENTEPHEMERIS_BINDING);
            protocolMarshaller.marshall(satelliteListItem.getGroundStations(), GROUNDSTATIONS_BINDING);
            protocolMarshaller.marshall((Object)satelliteListItem.getNoradSatelliteID(), NORADSATELLITEID_BINDING);
            protocolMarshaller.marshall((Object)satelliteListItem.getSatelliteArn(), SATELLITEARN_BINDING);
            protocolMarshaller.marshall((Object)satelliteListItem.getSatelliteId(), SATELLITEID_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

