/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.greengrassv2.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.greengrassv2.model.LambdaDeviceMount;
import com.amazonaws.services.greengrassv2.model.LambdaVolumeMount;
import com.amazonaws.services.greengrassv2.model.transform.LambdaContainerParamsMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class LambdaContainerParams
implements Serializable,
Cloneable,
StructuredPojo {
    private Integer memorySizeInKB;
    private Boolean mountROSysfs;
    private List<LambdaVolumeMount> volumes;
    private List<LambdaDeviceMount> devices;

    public void setMemorySizeInKB(Integer memorySizeInKB) {
        this.memorySizeInKB = memorySizeInKB;
    }

    public Integer getMemorySizeInKB() {
        return this.memorySizeInKB;
    }

    public LambdaContainerParams withMemorySizeInKB(Integer memorySizeInKB) {
        this.setMemorySizeInKB(memorySizeInKB);
        return this;
    }

    public void setMountROSysfs(Boolean mountROSysfs) {
        this.mountROSysfs = mountROSysfs;
    }

    public Boolean getMountROSysfs() {
        return this.mountROSysfs;
    }

    public LambdaContainerParams withMountROSysfs(Boolean mountROSysfs) {
        this.setMountROSysfs(mountROSysfs);
        return this;
    }

    public Boolean isMountROSysfs() {
        return this.mountROSysfs;
    }

    public List<LambdaVolumeMount> getVolumes() {
        return this.volumes;
    }

    public void setVolumes(Collection<LambdaVolumeMount> volumes) {
        if (volumes == null) {
            this.volumes = null;
            return;
        }
        this.volumes = new ArrayList<LambdaVolumeMount>(volumes);
    }

    public LambdaContainerParams withVolumes(LambdaVolumeMount ... volumes) {
        if (this.volumes == null) {
            this.setVolumes(new ArrayList<LambdaVolumeMount>(volumes.length));
        }
        for (LambdaVolumeMount ele : volumes) {
            this.volumes.add(ele);
        }
        return this;
    }

    public LambdaContainerParams withVolumes(Collection<LambdaVolumeMount> volumes) {
        this.setVolumes(volumes);
        return this;
    }

    public List<LambdaDeviceMount> getDevices() {
        return this.devices;
    }

    public void setDevices(Collection<LambdaDeviceMount> devices) {
        if (devices == null) {
            this.devices = null;
            return;
        }
        this.devices = new ArrayList<LambdaDeviceMount>(devices);
    }

    public LambdaContainerParams withDevices(LambdaDeviceMount ... devices) {
        if (this.devices == null) {
            this.setDevices(new ArrayList<LambdaDeviceMount>(devices.length));
        }
        for (LambdaDeviceMount ele : devices) {
            this.devices.add(ele);
        }
        return this;
    }

    public LambdaContainerParams withDevices(Collection<LambdaDeviceMount> devices) {
        this.setDevices(devices);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getMemorySizeInKB() != null) {
            sb.append("MemorySizeInKB: ").append(this.getMemorySizeInKB()).append(",");
        }
        if (this.getMountROSysfs() != null) {
            sb.append("MountROSysfs: ").append(this.getMountROSysfs()).append(",");
        }
        if (this.getVolumes() != null) {
            sb.append("Volumes: ").append(this.getVolumes()).append(",");
        }
        if (this.getDevices() != null) {
            sb.append("Devices: ").append(this.getDevices());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LambdaContainerParams)) {
            return false;
        }
        LambdaContainerParams other = (LambdaContainerParams)obj;
        if (other.getMemorySizeInKB() == null ^ this.getMemorySizeInKB() == null) {
            return false;
        }
        if (other.getMemorySizeInKB() != null && !other.getMemorySizeInKB().equals(this.getMemorySizeInKB())) {
            return false;
        }
        if (other.getMountROSysfs() == null ^ this.getMountROSysfs() == null) {
            return false;
        }
        if (other.getMountROSysfs() != null && !other.getMountROSysfs().equals(this.getMountROSysfs())) {
            return false;
        }
        if (other.getVolumes() == null ^ this.getVolumes() == null) {
            return false;
        }
        if (other.getVolumes() != null && !other.getVolumes().equals(this.getVolumes())) {
            return false;
        }
        if (other.getDevices() == null ^ this.getDevices() == null) {
            return false;
        }
        return other.getDevices() == null || other.getDevices().equals(this.getDevices());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getMemorySizeInKB() == null ? 0 : this.getMemorySizeInKB().hashCode());
        hashCode = 31 * hashCode + (this.getMountROSysfs() == null ? 0 : this.getMountROSysfs().hashCode());
        hashCode = 31 * hashCode + (this.getVolumes() == null ? 0 : this.getVolumes().hashCode());
        hashCode = 31 * hashCode + (this.getDevices() == null ? 0 : this.getDevices().hashCode());
        return hashCode;
    }

    public LambdaContainerParams clone() {
        try {
            return (LambdaContainerParams)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LambdaContainerParamsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

